/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.ChecksumBuilder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.PacketPropertiesLoader;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.UdpPort;
import org.pcap4j.util.ByteArrays;

public final class UdpPacket
extends AbstractPacket {
    private static final long serialVersionUID = 4638029542367352625L;
    private final UdpHeader header;
    private final Packet payload;

    public static UdpPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UdpPacket(rawData, offset, length);
    }

    private UdpPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new UdpHeader(rawData, offset, length);
        int payloadLength = this.header.getLengthAsInt() - this.header.length();
        if (payloadLength < 0) {
            throw new IllegalRawDataException("The value of length field seems to be wrong: " + this.header.getLengthAsInt());
        }
        if (payloadLength > length - this.header.length()) {
            payloadLength = length - this.header.length();
        }
        if (payloadLength != 0) {
            PacketFactory<Packet, UdpPort> factory = PacketFactories.getFactory(Packet.class, UdpPort.class);
            Class<Packet> class4UnknownPort = factory.getTargetClass();
            Class<Packet> class4DstPort = factory.getTargetClass(this.header.getDstPort());
            UdpPort serverPort = class4DstPort.equals(class4UnknownPort) ? this.header.getSrcPort() : this.header.getDstPort();
            this.payload = PacketFactories.getFactory(Packet.class, UdpPort.class).newInstance(rawData, offset + this.header.length(), payloadLength, serverPort);
        } else {
            this.payload = null;
        }
    }

    private UdpPacket(Builder builder) {
        if (builder == null || builder.srcPort == null || builder.dstPort == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.srcPort: ").append(builder.srcPort).append(" builder.dstPort: ").append(builder.dstPort);
            throw new NullPointerException(sb.toString());
        }
        if (builder.correctChecksumAtBuild) {
            if (builder.srcAddr == null || builder.dstAddr == null) {
                StringBuilder sb = new StringBuilder();
                sb.append("builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
                throw new NullPointerException(sb.toString());
            }
            if (!builder.srcAddr.getClass().isInstance(builder.dstAddr)) {
                StringBuilder sb = new StringBuilder();
                sb.append("builder.srcAddr: ").append(builder.srcAddr).append(" builder.dstAddr: ").append(builder.dstAddr);
                throw new IllegalArgumentException(sb.toString());
            }
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new UdpHeader(builder, this.payload != null ? this.payload.getRawData() : new byte[]{});
    }

    @Override
    public UdpHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public boolean hasValidChecksum(InetAddress srcAddr, InetAddress dstAddr, boolean acceptZero) {
        if (srcAddr == null || dstAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("srcAddr: ").append(srcAddr).append(" dstAddr: ").append(dstAddr);
            throw new NullPointerException(sb.toString());
        }
        if (!srcAddr.getClass().isInstance(dstAddr)) {
            StringBuilder sb = new StringBuilder();
            sb.append("srcAddr: ").append(srcAddr).append(" dstAddr: ").append(dstAddr);
            throw new IllegalArgumentException(sb.toString());
        }
        if (this.header.checksum == 0) {
            return acceptZero;
        }
        if (this.payload != null) {
            return this.header.calcChecksum(srcAddr, dstAddr, this.payload.getRawData()) == this.header.checksum;
        }
        return this.header.calcChecksum(srcAddr, dstAddr, new byte[0]) == this.header.checksum;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class UdpHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -1746545325551976324L;
        private static final int SRC_PORT_OFFSET = 0;
        private static final int SRC_PORT_SIZE = 2;
        private static final int DST_PORT_OFFSET = 2;
        private static final int DST_PORT_SIZE = 2;
        private static final int LENGTH_OFFSET = 4;
        private static final int LENGTH_SIZE = 2;
        private static final int CHECKSUM_OFFSET = 6;
        private static final int CHECKSUM_SIZE = 2;
        private static final int UCP_HEADER_SIZE = 8;
        private static final int IPV4_PSEUDO_HEADER_SIZE = 12;
        private static final int IPV6_PSEUDO_HEADER_SIZE = 40;
        private final UdpPort srcPort;
        private final UdpPort dstPort;
        private final short length;
        private final short checksum;

        private UdpHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 8) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build a UDP header(").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.srcPort = UdpPort.getInstance(ByteArrays.getShort(rawData, 0 + offset));
            this.dstPort = UdpPort.getInstance(ByteArrays.getShort(rawData, 2 + offset));
            this.length = ByteArrays.getShort(rawData, 4 + offset);
            this.checksum = ByteArrays.getShort(rawData, 6 + offset);
        }

        private UdpHeader(Builder builder, byte[] payload) {
            this.srcPort = builder.srcPort;
            this.dstPort = builder.dstPort;
            this.length = builder.correctLengthAtBuild ? (short)(payload.length + this.length()) : builder.length;
            this.checksum = builder.correctChecksumAtBuild ? (builder.srcAddr instanceof Inet4Address && PacketPropertiesLoader.getInstance().udpV4CalcChecksum() || builder.srcAddr instanceof Inet6Address && PacketPropertiesLoader.getInstance().udpV6CalcChecksum() ? this.calcChecksum(builder.srcAddr, builder.dstAddr, payload) : (short)0) : builder.checksum;
        }

        private short calcChecksum(InetAddress srcAddr, InetAddress dstAddr, byte[] payload) {
            int destPos;
            byte[] data;
            int pseudoHeaderSize;
            int totalLength = payload.length + this.length();
            boolean lowerLayerIsIpV4 = srcAddr instanceof Inet4Address;
            int n = pseudoHeaderSize = lowerLayerIsIpV4 ? 12 : 40;
            if (totalLength % 2 != 0) {
                data = new byte[totalLength + 1 + pseudoHeaderSize];
                destPos = totalLength + 1;
            } else {
                data = new byte[totalLength + pseudoHeaderSize];
                destPos = totalLength;
            }
            System.arraycopy(this.buildRawData(), 0, data, 0, this.length());
            System.arraycopy(payload, 0, data, this.length(), payload.length);
            for (int i = 0; i < 2; ++i) {
                data[6 + i] = 0;
            }
            System.arraycopy(srcAddr.getAddress(), 0, data, destPos, srcAddr.getAddress().length);
            System.arraycopy(dstAddr.getAddress(), 0, data, destPos += srcAddr.getAddress().length, dstAddr.getAddress().length);
            destPos += dstAddr.getAddress().length;
            destPos = lowerLayerIsIpV4 ? ++destPos : (destPos += 3);
            data[destPos] = (Byte)IpNumber.UDP.value();
            System.arraycopy(ByteArrays.toByteArray((short)totalLength), 0, data, ++destPos, 2);
            destPos += 2;
            return ByteArrays.calcChecksum(data);
        }

        public UdpPort getSrcPort() {
            return this.srcPort;
        }

        public UdpPort getDstPort() {
            return this.dstPort;
        }

        public short getLength() {
            return this.length;
        }

        public int getLengthAsInt() {
            return 0xFFFF & this.length;
        }

        public short getChecksum() {
            return this.checksum;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Short)this.srcPort.value()));
            rawFields.add(ByteArrays.toByteArray((Short)this.dstPort.value()));
            rawFields.add(ByteArrays.toByteArray(this.length));
            rawFields.add(ByteArrays.toByteArray(this.checksum));
            return rawFields;
        }

        @Override
        public int length() {
            return 8;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[UDP Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Source port: ").append(this.getSrcPort()).append(ls);
            sb.append("  Destination port: ").append(this.getDstPort()).append(ls);
            sb.append("  Length: ").append(this.getLengthAsInt()).append(" [bytes]").append(ls);
            sb.append("  Checksum: 0x").append(ByteArrays.toHexString(this.checksum, "")).append(ls);
            return sb.toString();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!this.getClass().isInstance(obj)) {
                return false;
            }
            UdpHeader other = (UdpHeader)obj;
            return this.checksum == other.checksum && this.length == other.length && this.srcPort.equals(other.srcPort) && this.dstPort.equals(other.dstPort);
        }

        @Override
        protected int calcHashCode() {
            int result = 17;
            result = 31 * result + this.srcPort.hashCode();
            result = 31 * result + this.dstPort.hashCode();
            result = 31 * result + this.length;
            result = 31 * result + this.checksum;
            return result;
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<UdpPacket>,
    ChecksumBuilder<UdpPacket> {
        private UdpPort srcPort;
        private UdpPort dstPort;
        private short length;
        private short checksum;
        private Packet.Builder payloadBuilder;
        private InetAddress srcAddr;
        private InetAddress dstAddr;
        private boolean correctLengthAtBuild;
        private boolean correctChecksumAtBuild;

        public Builder() {
        }

        public Builder(UdpPacket packet) {
            this.srcPort = packet.header.srcPort;
            this.dstPort = packet.header.dstPort;
            this.length = packet.header.length;
            this.checksum = packet.header.checksum;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder srcPort(UdpPort srcPort) {
            this.srcPort = srcPort;
            return this;
        }

        public Builder dstPort(UdpPort dstPort) {
            this.dstPort = dstPort;
            return this;
        }

        public Builder length(short length) {
            this.length = length;
            return this;
        }

        public Builder checksum(short checksum) {
            this.checksum = checksum;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder srcAddr(InetAddress srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public Builder dstAddr(InetAddress dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        public Builder correctChecksumAtBuild(boolean correctChecksumAtBuild) {
            this.correctChecksumAtBuild = correctChecksumAtBuild;
            return this;
        }

        @Override
        public UdpPacket build() {
            return new UdpPacket(this);
        }
    }
}

