/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteOrder;
import java.util.regex.Pattern;
import org.pcap4j.util.LinkLayerAddress;
import org.pcap4j.util.MacAddress;

public final class ByteArrays {
    public static final int BYTE_SIZE_IN_BYTES = 1;
    public static final int SHORT_SIZE_IN_BYTES = 2;
    public static final int INT_SIZE_IN_BYTES = 4;
    public static final int LONG_SIZE_IN_BYTES = 8;
    public static final int INET4_ADDRESS_SIZE_IN_BYTES = 4;
    public static final int INET6_ADDRESS_SIZE_IN_BYTES = 16;
    public static final int BYTE_SIZE_IN_BITS = 8;
    private static final Pattern NO_SEPARATOR_HEX_STRING_PATTERN = Pattern.compile("\\A([0-9a-fA-F][0-9a-fA-F])+\\z");

    private ByteArrays() {
        throw new AssertionError();
    }

    public static byte[] reverse(byte[] array) {
        byte[] rarray = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            rarray[i] = array[array.length - i - 1];
        }
        return rarray;
    }

    public static byte getByte(byte[] array, int offset) {
        ByteArrays.validateBounds(array, offset, 1);
        return array[offset];
    }

    public static byte[] toByteArray(byte value) {
        return new byte[]{value};
    }

    public static String toHexString(byte value, String separator) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value), separator);
    }

    public static short getShort(byte[] array, int offset) {
        return ByteArrays.getShort(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static short getShort(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 2);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return (short)(array[offset + 1] << 8 | 0xFF & array[offset]);
        }
        return (short)(array[offset] << 8 | 0xFF & array[offset + 1]);
    }

    public static byte[] toByteArray(short value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(short value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return new byte[]{(byte)value, (byte)(value >> 8)};
        }
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static String toHexString(short value, String separator) {
        return ByteArrays.toHexString(value, separator, ByteOrder.BIG_ENDIAN);
    }

    public static String toHexString(short value, String separator, ByteOrder bo) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value, bo), separator);
    }

    public static int getInt(byte[] array, int offset) {
        return ByteArrays.getInt(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static int getInt(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 4);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return array[offset + 3] << 24 | (0xFF & array[offset + 2]) << 16 | (0xFF & array[offset + 1]) << 8 | 0xFF & array[offset];
        }
        return array[offset] << 24 | (0xFF & array[offset + 1]) << 16 | (0xFF & array[offset + 2]) << 8 | 0xFF & array[offset + 3];
    }

    public static int getInt(byte[] array, int offset, int length) {
        return ByteArrays.getInt(array, offset, length, ByteOrder.BIG_ENDIAN);
    }

    public static int getInt(byte[] array, int offset, int length, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, length);
        if (length > 4) {
            StringBuilder sb = new StringBuilder(30).append("length must be equal or less than ").append(4).append(", but is: ").append(length);
            throw new IllegalArgumentException(sb.toString());
        }
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        int value = 0;
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            for (int i = offset + length - 1; i >= offset; --i) {
                value <<= 8;
                value |= 0xFF & array[i];
            }
        } else {
            for (int i = offset; i < offset + length; ++i) {
                value <<= 8;
                value |= 0xFF & array[i];
            }
        }
        return value;
    }

    public static byte[] toByteArray(int value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(int value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24)};
        }
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] toByteArray(int value, int length) {
        return ByteArrays.toByteArray(value, length, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(int value, int length, ByteOrder bo) {
        if (length > 4) {
            StringBuilder sb = new StringBuilder(30).append("length must be equal or less than ").append(4).append(", but is: ").append(length);
            throw new IllegalArgumentException(sb.toString());
        }
        byte[] arr = new byte[length];
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            for (int i = 0; i < length; ++i) {
                arr[length - i - 1] = (byte)(value >> 8 * i);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                arr[i] = (byte)(value >> 8 * i);
            }
        }
        return arr;
    }

    public static String toHexString(int value, String separator) {
        return ByteArrays.toHexString(value, separator, ByteOrder.BIG_ENDIAN);
    }

    public static String toHexString(int value, String separator, ByteOrder bo) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value, bo), separator);
    }

    public static long getLong(byte[] array, int offset) {
        return ByteArrays.getLong(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static long getLong(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 8);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return (long)array[offset + 7] << 56 | (0xFFL & (long)array[offset + 6]) << 48 | (0xFFL & (long)array[offset + 5]) << 40 | (0xFFL & (long)array[offset + 4]) << 32 | (0xFFL & (long)array[offset + 3]) << 24 | (0xFFL & (long)array[offset + 2]) << 16 | (0xFFL & (long)array[offset + 1]) << 8 | 0xFFL & (long)array[offset];
        }
        return (long)array[offset] << 56 | (0xFFL & (long)array[offset + 1]) << 48 | (0xFFL & (long)array[offset + 2]) << 40 | (0xFFL & (long)array[offset + 3]) << 32 | (0xFFL & (long)array[offset + 4]) << 24 | (0xFFL & (long)array[offset + 5]) << 16 | (0xFFL & (long)array[offset + 6]) << 8 | 0xFFL & (long)array[offset + 7];
    }

    public static byte[] toByteArray(long value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(long value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return new byte[]{(byte)value, (byte)(value >> 8), (byte)(value >> 16), (byte)(value >> 24), (byte)(value >> 32), (byte)(value >> 40), (byte)(value >> 48), (byte)(value >> 56)};
        }
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static String toHexString(long value, String separator) {
        return ByteArrays.toHexString(value, separator, ByteOrder.BIG_ENDIAN);
    }

    public static String toHexString(long value, String separator, ByteOrder bo) {
        return ByteArrays.toHexString(ByteArrays.toByteArray(value, bo), separator);
    }

    public static MacAddress getMacAddress(byte[] array, int offset) {
        return ByteArrays.getMacAddress(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static MacAddress getMacAddress(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 6);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return MacAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, 6)));
        }
        return MacAddress.getByAddress(ByteArrays.getSubArray(array, offset, 6));
    }

    public static byte[] toByteArray(MacAddress value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(MacAddress value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return ByteArrays.reverse(value.getAddress());
        }
        return value.getAddress();
    }

    public static LinkLayerAddress getLinkLayerAddress(byte[] array, int offset, int length) {
        return ByteArrays.getLinkLayerAddress(array, offset, length, ByteOrder.BIG_ENDIAN);
    }

    public static LinkLayerAddress getLinkLayerAddress(byte[] array, int offset, int length, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, length);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return LinkLayerAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, length)));
        }
        return LinkLayerAddress.getByAddress(ByteArrays.getSubArray(array, offset, length));
    }

    public static byte[] toByteArray(LinkLayerAddress value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(LinkLayerAddress value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return ByteArrays.reverse(value.getAddress());
        }
        return value.getAddress();
    }

    public static Inet4Address getInet4Address(byte[] array, int offset) {
        return ByteArrays.getInet4Address(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static Inet4Address getInet4Address(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 4);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        try {
            if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
                return (Inet4Address)InetAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, 4)));
            }
            return (Inet4Address)InetAddress.getByAddress(ByteArrays.getSubArray(array, offset, 4));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static Inet6Address getInet6Address(byte[] array, int offset) {
        return ByteArrays.getInet6Address(array, offset, ByteOrder.BIG_ENDIAN);
    }

    public static Inet6Address getInet6Address(byte[] array, int offset, ByteOrder bo) {
        ByteArrays.validateBounds(array, offset, 16);
        if (bo == null) {
            throw new NullPointerException(" bo: " + bo);
        }
        try {
            if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
                return (Inet6Address)InetAddress.getByAddress(ByteArrays.reverse(ByteArrays.getSubArray(array, offset, 16)));
            }
            return (Inet6Address)InetAddress.getByAddress(ByteArrays.getSubArray(array, offset, 16));
        }
        catch (UnknownHostException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static byte[] toByteArray(InetAddress value) {
        return ByteArrays.toByteArray(value, ByteOrder.BIG_ENDIAN);
    }

    public static byte[] toByteArray(InetAddress value, ByteOrder bo) {
        if (bo.equals(ByteOrder.LITTLE_ENDIAN)) {
            return ByteArrays.reverse(value.getAddress());
        }
        return value.getAddress();
    }

    public static byte[] getSubArray(byte[] array, int offset, int length) {
        ByteArrays.validateBounds(array, offset, length);
        byte[] subArray = new byte[length];
        System.arraycopy(array, offset, subArray, 0, length);
        return subArray;
    }

    public static byte[] getSubArray(byte[] array, int offset) {
        return ByteArrays.getSubArray(array, offset, array.length - offset);
    }

    public static String toHexString(byte[] array, String separator) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            buf.append(String.format("%02x", array[i]));
            buf.append(separator);
        }
        if (separator.length() != 0 && array.length > 0) {
            buf.delete(buf.lastIndexOf(separator), buf.length());
        }
        return buf.toString();
    }

    public static String toHexString(byte[] array, String separator, int offset, int length) {
        ByteArrays.validateBounds(array, offset, length);
        StringBuffer buf = new StringBuffer();
        for (int i = offset; i < offset + length; ++i) {
            buf.append(String.format("%02x", array[i]));
            buf.append(separator);
        }
        if (separator.length() != 0 && length > 0) {
            buf.delete(buf.lastIndexOf(separator), buf.length());
        }
        return buf.toString();
    }

    public static short calcChecksum(byte[] data) {
        long sum = 0L;
        for (int i = 1; i < data.length; i += 2) {
            sum += 0xFFFFL & (long)ByteArrays.getShort(data, i - 1);
        }
        if (data.length % 2 != 0) {
            sum += 0xFFFFL & (long)(data[data.length - 1] << 8);
        }
        while (sum >> 16 != 0L) {
            sum = (0xFFFFL & sum) + (sum >>> 16);
        }
        return (short)(sum ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static byte[] parseByteArray(String hexString, String separator) {
        String noSeparatorHexString;
        if (hexString == null || separator == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("hexString: ").append(hexString).append(" separator: ").append(separator);
            throw new NullPointerException(sb.toString());
        }
        if (hexString.startsWith("0x")) {
            hexString = hexString.substring(2);
        }
        if (separator.length() == 0) {
            if (!NO_SEPARATOR_HEX_STRING_PATTERN.matcher(hexString).matches()) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("invalid hex string(").append(hexString).append("), not match pattern(").append(NO_SEPARATOR_HEX_STRING_PATTERN.pattern()).append(")");
                throw new IllegalArgumentException(sb.toString());
            }
            noSeparatorHexString = hexString;
        } else {
            StringBuilder patternSb = new StringBuilder(60);
            patternSb.append("\\A[0-9a-fA-F][0-9a-fA-F](").append(Pattern.quote(separator)).append("[0-9a-fA-F][0-9a-fA-F])*\\z");
            String patternString = patternSb.toString();
            Pattern pattern = Pattern.compile(patternString);
            if (!pattern.matcher(hexString).matches()) {
                StringBuilder sb = new StringBuilder(150);
                sb.append("invalid hex string(").append(hexString).append("), not match pattern(").append(patternString).append(")");
                throw new IllegalArgumentException(sb.toString());
            }
            noSeparatorHexString = hexString.replaceAll(Pattern.quote(separator), "");
        }
        int arrayLength = noSeparatorHexString.length() / 2;
        byte[] array = new byte[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            array[i] = (byte)Integer.parseInt(noSeparatorHexString.substring(i * 2, i * 2 + 2), 16);
        }
        return array;
    }

    public static byte[] clone(byte[] array) {
        byte[] clone = new byte[array.length];
        System.arraycopy(array, 0, clone, 0, array.length);
        return clone;
    }

    public static void validateBounds(byte[] arr, int offset, int len) {
        if (arr == null) {
            throw new NullPointerException("arr must not be null.");
        }
        if (arr.length == 0) {
            throw new IllegalArgumentException("arr is empty.");
        }
        if (len == 0) {
            throw new IllegalArgumentException("length is zero.");
        }
        if (offset < 0 || len < 0 || offset + len > arr.length) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("arr.length: ").append(arr.length).append(", offset: ").append(offset).append(", len: ").append(len);
            throw new ArrayIndexOutOfBoundsException(sb.toString());
        }
    }
}

