/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.TcpPacket;
import org.pcap4j.packet.namednumber.TcpOptionKind;
import org.pcap4j.util.ByteArrays;

public final class UnknownTcpOption
implements TcpPacket.TcpOption {
    private static final long serialVersionUID = -893085251311518110L;
    private final TcpOptionKind kind;
    private final byte length;
    private final byte[] data;

    public static UnknownTcpOption newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new UnknownTcpOption(rawData, offset, length);
    }

    private UnknownTcpOption(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 2) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.kind = TcpOptionKind.getInstance(rawData[offset]);
        this.length = rawData[1 + offset];
        if (length < this.length) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data is too short to build this option(").append(this.length).append("). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.data = ByteArrays.getSubArray(rawData, 2 + offset, this.length - 2);
    }

    private UnknownTcpOption(Builder builder) {
        if (builder == null || builder.kind == null || builder.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.kind: ").append(builder.kind).append(" builder.data: ").append(builder.data);
            throw new NullPointerException(sb.toString());
        }
        this.kind = builder.kind;
        this.data = new byte[builder.data.length];
        System.arraycopy(builder.data, 0, this.data, 0, builder.data.length);
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public TcpOptionKind getKind() {
        return this.kind;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte[] getData() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.kind.value();
        rawData[1] = this.length;
        System.arraycopy(this.data, 0, rawData, 2, this.data.length);
        return rawData;
    }

    @Override
    public int length() {
        return this.data.length + 2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[Kind: ").append(this.kind).append("] [Length: ").append(this.getLengthAsInt()).append(" bytes] [Data: 0x").append(ByteArrays.toHexString(this.data, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((UnknownTcpOption)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    public static final class Builder
    implements LengthBuilder<UnknownTcpOption> {
        private TcpOptionKind kind;
        private byte length;
        private byte[] data;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(UnknownTcpOption option) {
            this.kind = option.kind;
            this.length = option.length;
            this.data = option.data;
        }

        public Builder kind(TcpOptionKind kind) {
            this.kind = kind;
            return this;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public UnknownTcpOption build() {
            return new UnknownTcpOption(this);
        }
    }
}

