/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Ssh2VersionExchangePacket
extends AbstractPacket {
    private static final long serialVersionUID = 936170241296151065L;
    private final Ssh2VersionExchangeHeader header;

    public static Ssh2VersionExchangePacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Ssh2VersionExchangePacket(rawData, offset, length);
    }

    private Ssh2VersionExchangePacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Ssh2VersionExchangeHeader(rawData, offset, length);
    }

    private Ssh2VersionExchangePacket(Builder builder) {
        if (builder == null || builder.protoVersion == null || builder.softwareVersion == null || builder.comments == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.protoVersion: ").append(builder.protoVersion).append(" builder.softwareVersion: ").append(builder.softwareVersion).append(" builder.comments: ").append(builder.comments);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2VersionExchangeHeader(builder);
    }

    @Override
    public Ssh2VersionExchangeHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Ssh2VersionExchangeHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -997040469918475251L;
        private final List<String> messages;
        private final String protoVersion;
        private final String softwareVersion;
        private final String comments;

        private Ssh2VersionExchangeHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            String data;
            if (length < 9) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too short to build an SSH2 version exchange header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            try {
                data = new String(rawData, offset, length, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new AssertionError((Object)"Never get here.");
            }
            String[] lines = data.split("\r\n", -1);
            this.messages = new ArrayList<String>();
            int versionIdx = -1;
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i].startsWith("SSH-")) {
                    versionIdx = i;
                    break;
                }
                this.messages.add(lines[i]);
            }
            if (versionIdx == -1) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data doesn't include the version string. data: ").append(data);
                throw new IllegalRawDataException(sb.toString());
            }
            if (lines.length < versionIdx + 2) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The version string must be terminated by CR LF. data: ").append(data);
                throw new IllegalRawDataException(sb.toString());
            }
            data = lines[versionIdx].substring(4);
            int hyphenIdx = data.indexOf("-");
            if (hyphenIdx == -1) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data must start with SSH-protoversion-softwareversion. data: ").append(data);
                throw new IllegalRawDataException(sb.toString());
            }
            this.protoVersion = data.substring(0, hyphenIdx);
            int spIdx = (data = data.substring(hyphenIdx + 1)).indexOf(" ");
            if (spIdx != -1) {
                this.softwareVersion = data.substring(0, spIdx);
                this.comments = data.substring(spIdx + 1, data.length());
            } else {
                this.softwareVersion = data.substring(0, data.length());
                this.comments = "";
            }
            if (this.length() > 255) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too long for an SSH version exchange header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
        }

        private Ssh2VersionExchangeHeader(Builder builder) {
            this.messages = builder.messages != null ? new ArrayList<String>(builder.messages) : new ArrayList<String>();
            this.protoVersion = builder.protoVersion;
            this.softwareVersion = builder.softwareVersion;
            this.comments = builder.comments;
            if (this.length() > 255) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is too long for an SSH version exchange header. data: ").append("builder.messages: [");
                Iterator<String> iter = this.messages.iterator();
                while (iter.hasNext()) {
                    String message = iter.next();
                    sb.append(message);
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append("]").append(" builder.protoVersion: ").append(builder.protoVersion).append(" builder.softwareVersion: ").append(builder.softwareVersion).append(" builder.comments: ").append(builder.comments);
                throw new IllegalArgumentException(sb.toString());
            }
        }

        public ArrayList<String> getMessages() {
            return new ArrayList<String>(this.messages);
        }

        public String getProtoVersion() {
            return this.protoVersion;
        }

        public String getSoftwareVersion() {
            return this.softwareVersion;
        }

        public String getComments() {
            return this.comments;
        }

        public String getEntireMessage() {
            StringBuilder sb = new StringBuilder(50);
            for (String message : this.messages) {
                sb.append(message).append("\r\n");
            }
            sb.append("SSH-").append(this.protoVersion).append("-").append(this.softwareVersion);
            if (this.comments.length() != 0) {
                sb.append(" ").append(this.comments);
            }
            sb.append("\r\n");
            return sb.toString();
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(this.getEntireMessage().getBytes());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.getEntireMessage().length();
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 Version Exchange Header (").append(this.length()).append(" bytes)]").append(ls);
            for (String line : this.getEntireMessage().split("\r\n")) {
                sb.append("  ").append(line).append(ls);
            }
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private List<String> messages;
        private String protoVersion;
        private String softwareVersion;
        private String comments;

        public Builder() {
        }

        private Builder(Ssh2VersionExchangePacket packet) {
            this.messages = packet.header.messages;
            this.protoVersion = packet.header.protoVersion;
            this.softwareVersion = packet.header.softwareVersion;
            this.comments = packet.header.comments;
        }

        public Builder messages(List<String> messages) {
            this.messages = messages;
            return this;
        }

        public Builder protoVersion(String protoVersion) {
            this.protoVersion = protoVersion;
            return this;
        }

        public Builder softwareVersion(String softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public Builder comments(String comments) {
            this.comments = comments;
            return this;
        }

        @Override
        public Ssh2VersionExchangePacket build() {
            return new Ssh2VersionExchangePacket(this);
        }
    }
}

