/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Ssh2MpInt
implements Serializable,
Comparable<Ssh2MpInt> {
    private static final long serialVersionUID = 5539706044412185073L;
    private final int length;
    private final byte[] value;

    public Ssh2MpInt(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        if (length < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = ByteArrays.getInt(rawData, offset);
        if (this.length < 0) {
            StringBuilder sb = new StringBuilder(120);
            sb.append("A mp-int the length of which is longer than 2147483647 is not supported. length: ").append((long)this.length & 0xFFFFFFFFL);
            throw new IllegalRawDataException(sb.toString());
        }
        this.value = ByteArrays.getSubArray(rawData, 4 + offset, this.length);
    }

    public Ssh2MpInt(long value) {
        byte[] valArr = ByteArrays.toByteArray(value);
        if (-128L <= value && 127L <= value) {
            valArr = ByteArrays.getSubArray(valArr, 7);
        } else if (-32768L <= value && value <= 32767L) {
            valArr = ByteArrays.getSubArray(valArr, 6);
        } else if (-8388608L <= value && value <= 0x7FFFFFL) {
            valArr = ByteArrays.getSubArray(valArr, 5);
        } else if (Integer.MIN_VALUE <= value && value <= Integer.MAX_VALUE) {
            valArr = ByteArrays.getSubArray(valArr, 4);
        } else if (0L <= value && value <= 0x7FFFFFFFFFL) {
            valArr = ByteArrays.getSubArray(valArr, 3);
        } else if (0L <= value && value <= 0x7FFFFFFFFFFFL) {
            valArr = ByteArrays.getSubArray(valArr, 2);
        } else if (0L <= value && value <= 0x7FFFFFFFFFFFFFL) {
            valArr = ByteArrays.getSubArray(valArr, 1);
        }
        this.value = valArr;
        this.length = this.value.length;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getValue() {
        return ByteArrays.clone(this.value);
    }

    public BigInteger getValueAsBigInteger() {
        return new BigInteger(this.value);
    }

    public int length() {
        return this.length + 4;
    }

    public byte[] getRawData() {
        byte[] rawData = new byte[this.length + 4];
        System.arraycopy(ByteArrays.toByteArray(this.length), 0, rawData, 0, 4);
        System.arraycopy(this.value, 0, rawData, 4, this.length);
        return rawData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getValueAsBigInteger()).append(" (").append(ByteArrays.toHexString(this.value, " ")).append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((Ssh2MpInt)obj).value, this.value);
    }

    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public int compareTo(Ssh2MpInt o) {
        return this.getValueAsBigInteger().compareTo(o.getValueAsBigInteger());
    }
}

