/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Ssh2MpInt;
import org.pcap4j.packet.Ssh2String;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2KexDhReplyPacket
extends AbstractPacket {
    private static final long serialVersionUID = 6507040765944406940L;
    private final Ssh2KexDhReplyHeader header;

    public static Ssh2KexDhReplyPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Ssh2KexDhReplyPacket(rawData, offset, length);
    }

    private Ssh2KexDhReplyPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new Ssh2KexDhReplyHeader(rawData, offset, length);
    }

    private Ssh2KexDhReplyPacket(Builder builder) {
        if (builder == null || builder.k_s == null || builder.f == null || builder.signatureOfH == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.k_s: ").append(builder.k_s).append(" builder.f: ").append(builder.f).append(" builder.signatureOfH: ").append(builder.signatureOfH);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2KexDhReplyHeader(builder);
    }

    @Override
    public Ssh2KexDhReplyHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Ssh2KexDhReplyHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 4008432145902117221L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_KEXDH_REPLY;
        private final Ssh2String k_s;
        private final Ssh2MpInt f;
        private final Ssh2String signatureOfH;

        private Ssh2KexDhReplyHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 13) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an SSH2 KEX DH reply header. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[offset]).equals(Ssh2MessageNumber.SSH_MSG_KEXDH_REPLY)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 KEX DH reply message. data: ").append(new String(rawData)).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            int currentOffset = 1 + offset;
            int remainingLength = length - 1;
            this.k_s = new Ssh2String(rawData, currentOffset, remainingLength);
            this.f = new Ssh2MpInt(rawData, currentOffset += this.k_s.length(), remainingLength -= this.k_s.length());
            this.signatureOfH = new Ssh2String(rawData, currentOffset += this.f.length(), remainingLength -= this.f.length());
        }

        private Ssh2KexDhReplyHeader(Builder builder) {
            this.k_s = builder.k_s;
            this.f = builder.f;
            this.signatureOfH = builder.signatureOfH;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public Ssh2String getK_s() {
            return this.k_s;
        }

        public Ssh2MpInt getF() {
            return this.f;
        }

        public Ssh2String getSignatureOfH() {
            return this.signatureOfH;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            rawFields.add(this.k_s.getRawData());
            rawFields.add(this.f.getRawData());
            rawFields.add(this.signatureOfH.getRawData());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.getRawData().length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 KEX DH reply Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            sb.append("  K_S: ").append(this.k_s).append(ls);
            sb.append("  f: ").append(this.f).append(ls);
            sb.append("  signature of H: ").append(this.signatureOfH).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private Ssh2String k_s;
        private Ssh2MpInt f;
        private Ssh2String signatureOfH;

        public Builder() {
        }

        private Builder(Ssh2KexDhReplyPacket packet) {
            this.k_s = packet.header.k_s;
            this.f = packet.header.f;
            this.signatureOfH = packet.header.signatureOfH;
        }

        public Builder k_s(Ssh2String k_s) {
            this.k_s = k_s;
            return this;
        }

        public Builder f(Ssh2MpInt f) {
            this.f = f;
            return this;
        }

        public Builder signatureOfH(Ssh2String signatureOfH) {
            this.signatureOfH = signatureOfH;
            return this;
        }

        @Override
        public Ssh2KexDhReplyPacket build() {
            return new Ssh2KexDhReplyPacket(this);
        }
    }
}

