/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.packet.namednumber.IpV6OptionType;
import org.pcap4j.util.ByteArrays;

public abstract class IpV6ExtOptionsPacket
extends AbstractPacket {
    private final Packet payload;
    private static final long serialVersionUID = 416178196599916582L;

    protected IpV6ExtOptionsPacket() {
        this.payload = null;
    }

    protected IpV6ExtOptionsPacket(byte[] rawData, int payloadOffset, int payloadLength, IpNumber number) {
        this.payload = PacketFactories.getFactory(Packet.class, IpNumber.class).newInstance(rawData, payloadOffset, payloadLength, number);
    }

    protected IpV6ExtOptionsPacket(Builder builder) {
        if (builder == null || builder.nextHeader == null || builder.options == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.nextHeader: ").append(builder.nextHeader).append(" builder.options: ").append(builder.options);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
    }

    @Override
    public abstract IpV6ExtOptionsHeader getHeader();

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public static interface IpV6Option
    extends Serializable {
        public IpV6OptionType getType();

        public int length();

        public byte[] getRawData();
    }

    public static abstract class IpV6ExtOptionsHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 224822728201337667L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int HDR_EXT_LEN_OFFSET = 1;
        private static final int HDR_EXT_LEN_SIZE = 1;
        private static final int OPTIONS_OFFSET = 2;
        private final IpNumber nextHeader;
        private final byte hdrExtLen;
        private final List<IpV6Option> options;

        protected IpV6ExtOptionsHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            IpV6Option newOne;
            if (length < 2) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data length of ").append(this.getHeaderName()).append(" is must be more than 1. data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0 + offset));
            this.hdrExtLen = ByteArrays.getByte(rawData, 1 + offset);
            int headerLength = (this.getHdrExtLenAsInt() + 1) * 8;
            if (length < headerLength) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an ").append(this.getHeaderName()).append("(").append(headerLength).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.options = new ArrayList<IpV6Option>();
            for (int currentOffsetInHeader = 2; currentOffsetInHeader < headerLength; currentOffsetInHeader += newOne.length()) {
                IpV6OptionType type = IpV6OptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                try {
                    newOne = PacketFactories.getFactory(IpV6Option.class, IpV6OptionType.class).newInstance(rawData, currentOffsetInHeader + offset, headerLength - currentOffsetInHeader, type);
                }
                catch (Exception e) {
                    break;
                }
                this.options.add(newOne);
            }
        }

        protected IpV6ExtOptionsHeader(Builder builder) {
            int optLength = 0;
            for (IpV6Option o : builder.options) {
                optLength += o.length();
            }
            if ((optLength + 2) % 8 != 0) {
                StringBuilder sb = new StringBuilder(200);
                String ls = System.getProperty("line.separator");
                sb.append("options length is invalid.").append(" ([options length] + 2) % 8 must be 0.").append(" options: ").append(ls);
                for (IpV6Option opt : builder.options) {
                    sb.append(opt).append(ls);
                }
                throw new IllegalArgumentException(sb.toString());
            }
            this.nextHeader = builder.nextHeader;
            this.options = new ArrayList<IpV6Option>(builder.options);
            this.hdrExtLen = builder.correctLengthAtBuild ? (byte)((optLength + 2) / 8 - 1) : builder.hdrExtLen;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getHdrExtLen() {
            return this.hdrExtLen;
        }

        public int getHdrExtLenAsInt() {
            return 0xFF & this.hdrExtLen;
        }

        public List<IpV6Option> getOptions() {
            return new ArrayList<IpV6Option>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.hdrExtLen));
            for (IpV6Option o : this.options) {
                rawFields.add(o.getRawData());
            }
            return rawFields;
        }

        @Override
        public int calcLength() {
            int optLength = 0;
            for (IpV6Option o : this.options) {
                optLength += o.length();
            }
            return optLength + 2;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[").append(this.getHeaderName()).append(" (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Next Header: ").append(this.nextHeader).append(ls);
            sb.append("  Hdr Ext Len: ").append(this.getHdrExtLenAsInt()).append(" (").append((this.getHdrExtLenAsInt() + 1) * 8).append(" [bytes])").append(ls);
            sb.append("  Options: ").append(ls);
            for (IpV6Option opt : this.options) {
                sb.append("    ").append(opt).append(ls);
            }
            return sb.toString();
        }

        protected abstract String getHeaderName();
    }

    public static abstract class Builder
    extends AbstractPacket.AbstractBuilder
    implements LengthBuilder<IpV6ExtOptionsPacket> {
        private IpNumber nextHeader;
        private byte hdrExtLen;
        private List<IpV6Option> options;
        private Packet.Builder payloadBuilder;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        protected Builder(IpV6ExtOptionsPacket packet) {
            this.nextHeader = packet.getHeader().nextHeader;
            this.hdrExtLen = packet.getHeader().hdrExtLen;
            this.options = packet.getHeader().options;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder hdrExtLen(byte hdrExtLen) {
            this.hdrExtLen = hdrExtLen;
            return this;
        }

        public Builder options(List<IpV6Option> options) {
            this.options = options;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }
    }
}

