/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.IpV6Packet;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.packet.namednumber.IpVersion;
import org.pcap4j.util.ByteArrays;

public final class IpPacket
extends AbstractPacket {
    private static final long serialVersionUID = -1L;

    public static Packet newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        int ipVersion = rawData[offset] >> 4 & 0xF;
        if (ipVersion == ((Byte)IpVersion.IPV4.value()).intValue()) {
            return IpV4Packet.newPacket(rawData, offset, length);
        }
        if (ipVersion == ((Byte)IpVersion.IPV6.value()).intValue()) {
            return IpV6Packet.newPacket(rawData, offset, length);
        }
        return UnknownPacket.newPacket(rawData, offset, length);
    }

    private IpPacket() {
        throw new AssertionError();
    }

    @Override
    public Packet.Builder getBuilder() {
        throw new UnsupportedOperationException();
    }
}

