/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.util.ByteArrays;

public final class IllegalIpV6RoutingData
implements IpV6ExtRoutingPacket.IpV6RoutingData {
    private static final long serialVersionUID = -6359533865311266265L;
    private final byte[] rawData;

    public static IllegalIpV6RoutingData newInstance(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IllegalIpV6RoutingData(rawData, offset, length);
    }

    private IllegalIpV6RoutingData(byte[] rawData, int offset, int length) {
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, this.rawData.length);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[illegal data: ").append(ByteArrays.toHexString(this.rawData, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IllegalIpV6RoutingData)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }
}

