/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV6CommonPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpV6NeighborDiscoveryOptionType;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6RouterSolicitationPacket
extends AbstractPacket {
    private static final long serialVersionUID = -8012525256314872386L;
    private final IcmpV6RouterSolicitationHeader header;

    public static IcmpV6RouterSolicitationPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new IcmpV6RouterSolicitationPacket(rawData, offset, length);
    }

    private IcmpV6RouterSolicitationPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new IcmpV6RouterSolicitationHeader(rawData, offset, length);
    }

    private IcmpV6RouterSolicitationPacket(Builder builder) {
        if (builder == null || builder.options == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.options: ").append(builder.options);
            throw new NullPointerException(sb.toString());
        }
        this.header = new IcmpV6RouterSolicitationHeader(builder);
    }

    @Override
    public IcmpV6RouterSolicitationHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6RouterSolicitationHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -6091118158605916309L;
        private static final int RESERVED_OFFSET = 0;
        private static final int RESERVED_SIZE = 4;
        private static final int OPTIONS_OFFSET = 4;
        private final int reserved;
        private final List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        private IcmpV6RouterSolicitationHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            IcmpV6CommonPacket.IpV6NeighborDiscoveryOption newOne;
            if (length < 4) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The raw data must be more than ").append(3).append("bytes").append(" to build this header. raw data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset);
                throw new IllegalRawDataException(sb.toString());
            }
            this.reserved = ByteArrays.getInt(rawData, 0 + offset);
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>();
            for (int currentOffsetInHeader = 4; currentOffsetInHeader < length; currentOffsetInHeader += newOne.length()) {
                IpV6NeighborDiscoveryOptionType type = IpV6NeighborDiscoveryOptionType.getInstance(rawData[currentOffsetInHeader + offset]);
                try {
                    newOne = PacketFactories.getFactory(IcmpV6CommonPacket.IpV6NeighborDiscoveryOption.class, IpV6NeighborDiscoveryOptionType.class).newInstance(rawData, currentOffsetInHeader + offset, length - currentOffsetInHeader, type);
                }
                catch (Exception e) {
                    break;
                }
                this.options.add(newOne);
            }
        }

        private IcmpV6RouterSolicitationHeader(Builder builder) {
            this.reserved = builder.reserved;
            this.options = new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(builder.options);
        }

        public int getReserved() {
            return this.reserved;
        }

        public List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> getOptions() {
            return new ArrayList<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption>(this.options);
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                rawFields.add(o.getRawData());
            }
            return rawFields;
        }

        @Override
        protected int calcLength() {
            int len = 0;
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption o : this.options) {
                len += o.length();
            }
            return len + 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv6 Router Solicitation Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Reserved: ").append(this.reserved).append(ls);
            for (IcmpV6CommonPacket.IpV6NeighborDiscoveryOption opt : this.options) {
                sb.append("  Option: ").append(opt).append(ls);
            }
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private int reserved;
        private List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options;

        public Builder() {
        }

        private Builder(IcmpV6RouterSolicitationPacket packet) {
            this.reserved = packet.header.reserved;
            this.options = packet.header.options;
        }

        public Builder reserved(int reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder options(List<IcmpV6CommonPacket.IpV6NeighborDiscoveryOption> options) {
            this.options = options;
            return this;
        }

        @Override
        public IcmpV6RouterSolicitationPacket build() {
            return new IcmpV6RouterSolicitationPacket(this);
        }
    }
}

