/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

abstract class IcmpIdentifiablePacket
extends AbstractPacket {
    private static final long serialVersionUID = -424401780940103043L;

    protected IcmpIdentifiablePacket() {
    }

    protected IcmpIdentifiablePacket(Builder builder) {
        if (builder == null) {
            throw new NullPointerException("builder: " + builder);
        }
    }

    @Override
    public abstract IcmpIdentifiableHeader getHeader();

    static abstract class IcmpIdentifiableHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 8141956422232700L;
        private static final int IDENTIFIER_OFFSET = 0;
        private static final int IDENTIFIER_SIZE = 2;
        private static final int SEQUENCE_NUMBER_OFFSET = 2;
        private static final int SEQUENCE_NUMBER_SIZE = 2;
        protected static final int ICMP_IDENTIFIABLE_HEADER_SIZE = 4;
        private final short identifier;
        private final short sequenceNumber;

        protected IcmpIdentifiableHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ").append(this.getHeaderName()).append("(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.identifier = ByteArrays.getShort(rawData, 0 + offset);
            this.sequenceNumber = ByteArrays.getShort(rawData, 2 + offset);
        }

        protected IcmpIdentifiableHeader(Builder builder) {
            this.identifier = builder.identifier;
            this.sequenceNumber = builder.sequenceNumber;
        }

        public short getIdentifier() {
            return this.identifier;
        }

        public int getIdentifierAsInt() {
            return this.identifier & 0xFFFF;
        }

        public short getSequenceNumber() {
            return this.sequenceNumber;
        }

        public int getSequenceNumberAsInt() {
            return this.sequenceNumber & 0xFFFF;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.identifier));
            rawFields.add(ByteArrays.toByteArray(this.sequenceNumber));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[").append(this.getHeaderName()).append(" (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Identifier: ").append(this.getIdentifierAsInt()).append(ls);
            sb.append("  SequenceNumber: ").append(this.getSequenceNumberAsInt()).append(ls);
            return sb.toString();
        }

        protected abstract String getHeaderName();
    }

    static abstract class Builder
    extends AbstractPacket.AbstractBuilder {
        private short identifier;
        private short sequenceNumber;

        public Builder() {
        }

        protected Builder(IcmpIdentifiablePacket packet) {
            this.identifier = packet.getHeader().identifier;
            this.sequenceNumber = packet.getHeader().sequenceNumber;
        }

        public Builder identifier(short identifier) {
            this.identifier = identifier;
            return this;
        }

        public Builder sequenceNumber(short sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return this;
        }
    }
}

