/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.util.ByteArrays;

public final class FragmentedPacket
extends AbstractPacket {
    private static final long serialVersionUID = -3607736905600980227L;
    private final byte[] rawData;

    public static FragmentedPacket newPacket(byte[] rawData, int offset, int length) {
        ByteArrays.validateBounds(rawData, offset, length);
        return new FragmentedPacket(rawData, offset, length);
    }

    private FragmentedPacket(byte[] rawData, int offset, int length) {
        this.rawData = new byte[length];
        System.arraycopy(rawData, offset, this.rawData, 0, length);
    }

    private FragmentedPacket(Builder builder) {
        if (builder == null || builder.rawData == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.rawData: ").append(builder.rawData);
            throw new NullPointerException(sb.toString());
        }
        this.rawData = new byte[builder.rawData.length];
        System.arraycopy(builder.rawData, 0, this.rawData, 0, builder.rawData.length);
    }

    @Override
    public int length() {
        return this.rawData.length;
    }

    @Override
    public byte[] getRawData() {
        byte[] copy = new byte[this.rawData.length];
        System.arraycopy(this.rawData, 0, copy, 0, copy.length);
        return copy;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append("[Fragmented data (").append(this.length()).append(" bytes)]").append(ls);
        sb.append("  Hex stream: ").append(ByteArrays.toHexString(this.rawData, " ")).append(ls);
        return sb.toString();
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte[] rawData;

        public Builder() {
        }

        private Builder(FragmentedPacket packet) {
            this.rawData = packet.rawData;
        }

        public Builder rawData(byte[] rawData) {
            this.rawData = rawData;
            return this;
        }

        @Override
        public FragmentedPacket build() {
            return new FragmentedPacket(this);
        }
    }
}

