/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.MacAddress;

public final class EthernetPacket
extends AbstractPacket {
    private static final long serialVersionUID = 3461432646404254300L;
    private static final int MIN_ETHERNET_PAYLOAD_LENGTH = 46;
    private final EthernetHeader header;
    private final Packet payload;
    private final byte[] pad;

    public static EthernetPacket newPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new EthernetPacket(rawData, offset, length);
    }

    private EthernetPacket(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        this.header = new EthernetHeader(rawData, offset, length);
        int payloadAndPadLength = length - this.header.length();
        if (payloadAndPadLength > 0) {
            int payloadOffset = offset + this.header.length();
            this.payload = PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawData, payloadOffset, payloadAndPadLength, this.header.getType());
            int padLength = payloadAndPadLength - this.payload.length();
            this.pad = padLength > 0 ? ByteArrays.getSubArray(rawData, payloadOffset + this.payload.length(), padLength) : new byte[0];
        } else {
            this.payload = null;
            this.pad = new byte[0];
        }
    }

    private EthernetPacket(Builder builder) {
        int payloadLength;
        if (builder == null || builder.dstAddr == null || builder.srcAddr == null || builder.type == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.dstAddr: ").append(builder.dstAddr).append(" builder.srcAddr: ").append(builder.srcAddr).append(" builder.type: ").append(builder.type);
            throw new NullPointerException(sb.toString());
        }
        if (!builder.paddingAtBuild && builder.pad == null) {
            throw new NullPointerException("builder.pad must not be null if builder.paddingAtBuild is false");
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new EthernetHeader(builder);
        int n = payloadLength = this.payload != null ? this.payload.length() : 0;
        if (builder.paddingAtBuild) {
            this.pad = payloadLength < 46 ? new byte[46 - payloadLength] : new byte[0];
        } else {
            this.pad = new byte[builder.pad.length];
            System.arraycopy(builder.pad, 0, this.pad, 0, builder.pad.length);
        }
    }

    @Override
    public EthernetHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    public byte[] getPad() {
        byte[] copy = new byte[this.pad.length];
        System.arraycopy(this.pad, 0, copy, 0, this.pad.length);
        return copy;
    }

    @Override
    protected int calcLength() {
        int length = super.calcLength();
        return length += this.pad.length;
    }

    @Override
    protected byte[] buildRawData() {
        byte[] rawData = super.buildRawData();
        if (this.pad.length != 0) {
            System.arraycopy(this.pad, 0, rawData, rawData.length - this.pad.length, this.pad.length);
        }
        return rawData;
    }

    @Override
    protected String buildString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.header.toString());
        if (this.payload != null) {
            sb.append(this.payload.toString());
        }
        if (this.pad.length != 0) {
            String ls = System.getProperty("line.separator");
            sb.append("[Ethernet Pad (").append(this.pad.length).append(" bytes)]").append(ls).append("  Hex stream: ").append(ByteArrays.toHexString(this.pad, " ")).append(ls);
        }
        return sb.toString();
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class EthernetHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -8271269099161190389L;
        private static final int DST_ADDR_OFFSET = 0;
        private static final int DST_ADDR_SIZE = 6;
        private static final int SRC_ADDR_OFFSET = 6;
        private static final int SRC_ADDR_SIZE = 6;
        private static final int TYPE_OFFSET = 12;
        private static final int TYPE_SIZE = 2;
        private static final int ETHERNET_HEADER_SIZE = 14;
        private final MacAddress dstAddr;
        private final MacAddress srcAddr;
        private final EtherType type;

        private EthernetHeader(byte[] rawData, int offset, int length) throws IllegalRawDataException {
            if (length < 14) {
                StringBuilder sb = new StringBuilder(100);
                sb.append("The data is too short to build an Ethernet header(").append(14).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
                throw new IllegalRawDataException(sb.toString());
            }
            this.dstAddr = ByteArrays.getMacAddress(rawData, 0 + offset);
            this.srcAddr = ByteArrays.getMacAddress(rawData, 6 + offset);
            this.type = EtherType.getInstance(ByteArrays.getShort(rawData, 12 + offset));
        }

        private EthernetHeader(Builder builder) {
            this.dstAddr = builder.dstAddr;
            this.srcAddr = builder.srcAddr;
            this.type = builder.type;
        }

        public MacAddress getDstAddr() {
            return this.dstAddr;
        }

        public MacAddress getSrcAddr() {
            return this.srcAddr;
        }

        public EtherType getType() {
            return this.type;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.dstAddr));
            rawFields.add(ByteArrays.toByteArray(this.srcAddr));
            rawFields.add(ByteArrays.toByteArray((Short)this.type.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 14;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[Ethernet Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Destination address: ").append(this.dstAddr).append(ls);
            sb.append("  Source address: ").append(this.srcAddr).append(ls);
            sb.append("  Type: ").append(this.type).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private MacAddress dstAddr;
        private MacAddress srcAddr;
        private EtherType type;
        private Packet.Builder payloadBuilder;
        private byte[] pad;
        private boolean paddingAtBuild;

        public Builder() {
        }

        private Builder(EthernetPacket packet) {
            this.dstAddr = packet.header.dstAddr;
            this.srcAddr = packet.header.srcAddr;
            this.type = packet.header.type;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
            this.pad = new byte[packet.pad.length];
            System.arraycopy(packet.pad, 0, this.pad, 0, packet.pad.length);
        }

        public Builder dstAddr(MacAddress dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public Builder srcAddr(MacAddress srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public Builder type(EtherType type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Builder pad(byte[] pad) {
            this.pad = pad;
            return this;
        }

        public Builder paddingAtBuild(boolean paddingAtBuild) {
            this.paddingAtBuild = paddingAtBuild;
            return this;
        }

        @Override
        public EthernetPacket build() {
            return new EthernetPacket(this);
        }
    }
}

