/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.LengthBuilder;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class UnknownIpV4Option
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = 5843622351774970021L;
    private final IpV4OptionType type;
    private final byte length;
    private final byte[] data;

    public static UnknownIpV4Option newInstance(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new UnknownIpV4Option(rawData);
    }

    private UnknownIpV4Option(byte[] rawData) throws IllegalRawDataException {
        if (rawData.length < 2) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be more than 1. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.type = IpV4OptionType.getInstance(rawData[0]);
        this.length = rawData[1];
        this.data = ByteArrays.getSubArray(rawData, 2, this.length - 2);
    }

    private UnknownIpV4Option(Builder builder) {
        if (builder == null || builder.type == null || builder.data == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.data: ").append(builder.data);
            throw new NullPointerException(sb.toString());
        }
        this.type = builder.type;
        this.data = new byte[builder.data.length];
        System.arraycopy(builder.data, 0, this.data, 0, builder.data.length);
        this.length = builder.correctLengthAtBuild ? (byte)this.length() : builder.length;
    }

    @Override
    public IpV4OptionType getType() {
        return this.type;
    }

    public byte getLength() {
        return this.length;
    }

    public int getLengthAsInt() {
        return 0xFF & this.length;
    }

    public byte[] getData() {
        byte[] copy = new byte[this.data.length];
        System.arraycopy(this.data, 0, copy, 0, this.data.length);
        return copy;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.type.value();
        rawData[1] = this.length;
        System.arraycopy(this.data, 0, rawData, 2, this.data.length);
        return rawData;
    }

    @Override
    public int length() {
        return this.data.length + 2;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(this.type).append("] [option-length: ").append(this.getLengthAsInt()).append(" bytes] [option-data: 0x").append(ByteArrays.toHexString(this.data, "")).append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((UnknownIpV4Option)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }

    public static final class Builder
    implements LengthBuilder<UnknownIpV4Option> {
        private IpV4OptionType type;
        private byte length;
        private byte[] data;
        private boolean correctLengthAtBuild;

        public Builder() {
        }

        private Builder(UnknownIpV4Option option) {
            this.type = option.type;
            this.length = option.length;
            this.data = option.data;
        }

        public Builder type(IpV4OptionType type) {
            this.type = type;
            return this;
        }

        public Builder length(byte length) {
            this.length = length;
            return this;
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            this.correctLengthAtBuild = correctLengthAtBuild;
            return this;
        }

        @Override
        public UnknownIpV4Option build() {
            return new UnknownIpV4Option(this);
        }
    }
}

