/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV6ExtRoutingPacket;
import org.pcap4j.util.ByteArrays;

public final class IpV6RoutingSourceRouteData
implements IpV6ExtRoutingPacket.IpV6RoutingData {
    private static final long serialVersionUID = -7972526977248222954L;
    private final int reserved;
    private final List<Inet6Address> addresses;

    public static IpV6RoutingSourceRouteData newInstance(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IpV6RoutingSourceRouteData(rawData);
    }

    private IpV6RoutingSourceRouteData(byte[] rawData) throws IllegalRawDataException {
        if (rawData.length < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        if ((rawData.length - 4) % 16 != 0) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("(rawData.length -4 ) % ").append(16).append(" must be 0. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.reserved = ByteArrays.getInt(rawData, 0);
        this.addresses = new ArrayList<Inet6Address>();
        for (int i = 4; i < rawData.length; i += 16) {
            this.addresses.add(ByteArrays.getInet6Address(rawData, i));
        }
    }

    public IpV6RoutingSourceRouteData(int reserved, List<Inet6Address> addresses) {
        if (addresses == null) {
            throw new NullPointerException("addresses must not be null");
        }
        this.reserved = reserved;
        this.addresses = new ArrayList<Inet6Address>(addresses);
    }

    @Override
    public int length() {
        return this.addresses.size() * 16 + 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        System.arraycopy(ByteArrays.toByteArray(this.reserved), 0, rawData, 0, 4);
        Iterator<Inet6Address> iter = this.addresses.iterator();
        for (int i = 4; i < rawData.length; i += 16) {
            System.arraycopy(ByteArrays.toByteArray(iter.next()), 0, rawData, i, 16);
        }
        return rawData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[reserved: ").append(this.reserved).append("] [addresses:");
        for (Inet6Address addr : this.addresses) {
            sb.append(" ").append(addr);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV6RoutingSourceRouteData)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }
}

