/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.FragmentedPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.IpNumber;
import org.pcap4j.util.ByteArrays;

public final class IpV6ExtFragmentPacket
extends AbstractPacket {
    private static final long serialVersionUID = 8789423734186381406L;
    private final IpV6ExtFragmentHeader header;
    private final Packet payload;

    public static IpV6ExtFragmentPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IpV6ExtFragmentPacket(rawData);
    }

    private IpV6ExtFragmentPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new IpV6ExtFragmentHeader(rawData);
        int payloadLength = rawData.length - this.header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), payloadLength);
            this.payload = this.header.m || this.header.fragmentOffset != 0 ? FragmentedPacket.newPacket(rawPayload) : PacketFactories.getFactory(Packet.class, IpNumber.class).newInstance(rawPayload, this.header.getNextHeader());
        } else {
            this.payload = null;
        }
    }

    private IpV6ExtFragmentPacket(Builder builder) {
        if (builder == null || builder.nextHeader == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.nextHeader: ").append(builder.nextHeader);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IpV6ExtFragmentHeader(builder);
    }

    @Override
    public IpV6ExtFragmentHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IpV6ExtFragmentHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 3488980383672562461L;
        private static final int NEXT_HEADER_OFFSET = 0;
        private static final int NEXT_HEADER_SIZE = 1;
        private static final int RESERVED_OFFSET = 1;
        private static final int RESERVED_SIZE = 1;
        private static final int FRAGMENT_OFFSET_AND_RES_AND_M_OFFSET = 2;
        private static final int FFRAGMENT_OFFSET_AND_RES_AND_M_SIZE = 2;
        private static final int IDENTIFICATION_OFFSET = 4;
        private static final int IDENTIFICATION_SIZE = 4;
        private static final int IPV6_EXT_FRAGMENT_HEADER_SIZE = 8;
        private final IpNumber nextHeader;
        private final byte reserved;
        private final short fragmentOffset;
        private final byte res;
        private final boolean m;
        private final int identification;

        private IpV6ExtFragmentHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 8) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an IPv6 fragment header(").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.nextHeader = IpNumber.getInstance(ByteArrays.getByte(rawData, 0));
            this.reserved = ByteArrays.getByte(rawData, 1);
            short fragmentOffsetAndResAndM = ByteArrays.getShort(rawData, 2);
            this.fragmentOffset = (short)((fragmentOffsetAndResAndM & 0xFFF8) >> 3);
            this.res = (byte)((fragmentOffsetAndResAndM & 6) >> 1);
            this.m = (fragmentOffsetAndResAndM & 1) == 1;
            this.identification = ByteArrays.getInt(rawData, 4);
        }

        private IpV6ExtFragmentHeader(Builder builder) {
            if ((builder.fragmentOffset & 0xE000) != 0) {
                throw new IllegalArgumentException("Invalid fragmentOffset: " + builder.fragmentOffset);
            }
            if ((builder.res & 0xFFFC) != 0) {
                throw new IllegalArgumentException("Invalid res: " + builder.res);
            }
            this.nextHeader = builder.nextHeader;
            this.reserved = builder.reserved;
            this.fragmentOffset = builder.fragmentOffset;
            this.res = builder.res;
            this.m = builder.m;
            this.identification = builder.identification;
        }

        public IpNumber getNextHeader() {
            return this.nextHeader;
        }

        public byte getReserved() {
            return this.reserved;
        }

        public short getFragmentOffset() {
            return this.fragmentOffset;
        }

        public byte getRes() {
            return this.res;
        }

        public boolean getM() {
            return this.m;
        }

        public int getIdentification() {
            return this.identification;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((Byte)this.nextHeader.value()));
            rawFields.add(ByteArrays.toByteArray(this.reserved));
            rawFields.add(ByteArrays.toByteArray((short)(this.fragmentOffset << 3 | this.res << 1 | (this.m ? 1 : 0))));
            rawFields.add(ByteArrays.toByteArray(this.identification));
            return rawFields;
        }

        @Override
        public int length() {
            return 8;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IPv6 Fragment Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Next Header: ").append(this.nextHeader).append(ls);
            sb.append("  Reserved: ").append(ByteArrays.toHexString(this.reserved, " ")).append(ls);
            sb.append("  Fragment Offset: ").append(this.fragmentOffset).append(ls);
            sb.append("  Res: ").append(ByteArrays.toHexString(this.res, " ")).append(ls);
            sb.append("  M: ").append(this.m).append(ls);
            sb.append("  Identification: ").append(this.identification).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private IpNumber nextHeader;
        private byte reserved;
        private short fragmentOffset;
        private byte res;
        private boolean m;
        private int identification;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        public Builder(IpV6ExtFragmentPacket packet) {
            this.nextHeader = packet.header.nextHeader;
            this.reserved = packet.header.reserved;
            this.fragmentOffset = packet.header.fragmentOffset;
            this.res = packet.header.res;
            this.m = packet.header.m;
            this.identification = packet.header.identification;
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        public Builder nextHeader(IpNumber nextHeader) {
            this.nextHeader = nextHeader;
            return this;
        }

        public Builder reserved(byte reserved) {
            this.reserved = reserved;
            return this;
        }

        public Builder fragmentOffset(short fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public Builder res(byte res) {
            this.res = res;
            return this;
        }

        public Builder m(boolean m) {
            this.m = m;
            return this;
        }

        public Builder identification(int identification) {
            this.identification = identification;
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public IpV6ExtFragmentPacket build() {
            return new IpV6ExtFragmentPacket(this);
        }
    }
}

