/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Ssh2String;
import org.pcap4j.packet.namednumber.Ssh2DisconnectionReasonCode;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2DisconnectPacket
extends AbstractPacket {
    private static final long serialVersionUID = -1484749154591150073L;
    private final Ssh2DisconnectHeader header;

    public static Ssh2DisconnectPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new Ssh2DisconnectPacket(rawData);
    }

    private Ssh2DisconnectPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new Ssh2DisconnectHeader(rawData);
    }

    private Ssh2DisconnectPacket(Builder builder) {
        if (builder == null || builder.reasonCode == null || builder.description == null || builder.languageTag == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.reasonCode: ").append(builder.reasonCode).append(" builder.description: ").append(builder.description).append(" builder.languageTag: ").append(builder.languageTag);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2DisconnectHeader(builder);
    }

    @Override
    public Ssh2DisconnectHeader getHeader() {
        return this.header;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class Ssh2DisconnectHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 873479096967096846L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_DISCONNECT;
        private final Ssh2DisconnectionReasonCode reasonCode;
        private final Ssh2String description;
        private final Ssh2String languageTag;

        private Ssh2DisconnectHeader(byte[] rawData) throws IllegalRawDataException {
            if (rawData.length < 13) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an SSH2 Disconnect header. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[0]).equals(Ssh2MessageNumber.SSH_MSG_DISCONNECT)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 Disconnect message. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
            int offset = 1;
            this.reasonCode = Ssh2DisconnectionReasonCode.getInstance(ByteArrays.getInt(rawData, offset));
            this.description = new Ssh2String(ByteArrays.getSubArray(rawData, offset += 4));
            this.languageTag = new Ssh2String(ByteArrays.getSubArray(rawData, offset += this.description.length()));
        }

        private Ssh2DisconnectHeader(Builder builder) {
            this.reasonCode = builder.reasonCode;
            this.description = builder.description;
            this.languageTag = builder.languageTag;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public Ssh2DisconnectionReasonCode getReasonCode() {
            return this.reasonCode;
        }

        public Ssh2String getDescription() {
            return this.description;
        }

        public Ssh2String getLanguageTag() {
            return this.languageTag;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            rawFields.add(ByteArrays.toByteArray((Integer)this.reasonCode.value()));
            rawFields.add(this.description.getRawData());
            rawFields.add(this.languageTag.getRawData());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.getRawData().length;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 Disconnect Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            sb.append("  reason code: ").append(this.reasonCode).append(ls);
            sb.append("  description: ").append(this.description).append(ls);
            sb.append("  language tag: ").append(this.languageTag).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private Ssh2DisconnectionReasonCode reasonCode;
        private Ssh2String description;
        private Ssh2String languageTag;

        public Builder() {
        }

        private Builder(Ssh2DisconnectPacket packet) {
            this.reasonCode = packet.header.reasonCode;
            this.description = packet.header.description;
            this.languageTag = packet.header.languageTag;
        }

        public Builder reasonCode(Ssh2DisconnectionReasonCode reasonCode) {
            this.reasonCode = reasonCode;
            return this;
        }

        public Builder description(Ssh2String description) {
            this.description = description;
            return this;
        }

        public Builder languageTag(Ssh2String languageTag) {
            this.languageTag = languageTag;
            return this;
        }

        @Override
        public Ssh2DisconnectPacket build() {
            return new Ssh2DisconnectPacket(this);
        }
    }
}

