/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.ObjectStreamException;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4Packet;
import org.pcap4j.packet.namednumber.IpV4OptionType;
import org.pcap4j.util.ByteArrays;

public final class IpV4EndOfOptionList
implements IpV4Packet.IpV4Option {
    private static final long serialVersionUID = 5323215977996813586L;
    private static final IpV4EndOfOptionList INSTANCE = new IpV4EndOfOptionList();
    private static final IpV4OptionType type = IpV4OptionType.END_OF_OPTION_LIST;

    private IpV4EndOfOptionList() {
    }

    public static IpV4EndOfOptionList getInstance() {
        return INSTANCE;
    }

    public static IpV4EndOfOptionList newInstance(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData may not be null");
        }
        if (rawData.length == 0) {
            throw new IllegalRawDataException("The raw data length must be more than 0");
        }
        if (rawData[0] != (Byte)type.value()) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The type must be: ").append(type.valueAsString()).append(" rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        return INSTANCE;
    }

    @Override
    public IpV4OptionType getType() {
        return type;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public byte[] getRawData() {
        return new byte[1];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[option-type: ").append(type);
        sb.append("]");
        return sb.toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

