/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6EchoReplyPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -3713149118572340972L;
    private final IcmpV6EchoReplyHeader header;
    private final Packet payload;

    public static IcmpV6EchoReplyPacket newPacket(byte[] rawData) throws IllegalRawDataException {
        if (rawData == null) {
            throw new NullPointerException("rawData must not be null.");
        }
        if (rawData.length == 0) {
            throw new IllegalArgumentException("rawData is empty.");
        }
        return new IcmpV6EchoReplyPacket(rawData);
    }

    private IcmpV6EchoReplyPacket(byte[] rawData) throws IllegalRawDataException {
        this.header = new IcmpV6EchoReplyHeader(rawData);
        int payloadLength = rawData.length - this.header.length();
        if (payloadLength > 0) {
            byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), payloadLength);
            this.payload = UnknownPacket.newPacket(rawPayload);
        } else {
            this.payload = null;
        }
    }

    private IcmpV6EchoReplyPacket(Builder builder) {
        super(builder);
        this.payload = builder.payloadBuilder != null ? builder.payloadBuilder.build() : null;
        this.header = new IcmpV6EchoReplyHeader(builder);
    }

    @Override
    public IcmpV6EchoReplyHeader getHeader() {
        return this.header;
    }

    @Override
    public Packet getPayload() {
        return this.payload;
    }

    @Override
    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6EchoReplyHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = -5140524898291969262L;

        private IcmpV6EchoReplyHeader(byte[] rawData) throws IllegalRawDataException {
            super(rawData);
        }

        private IcmpV6EchoReplyHeader(Builder builder) {
            super(builder);
        }

        @Override
        protected String getHeaderName() {
            return "ICMPv6 Echo Reply Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV6EchoReplyPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload != null ? packet.payload.getBuilder() : null;
        }

        @Override
        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        @Override
        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        @Override
        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        @Override
        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        @Override
        public IcmpV6EchoReplyPacket build() {
            return new IcmpV6EchoReplyPacket(this);
        }
    }
}

