/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArpHardwareType
extends NamedNumber<Short> {
    private static final long serialVersionUID = -4679864421785826910L;
    public static final ArpHardwareType ETHERNET = new ArpHardwareType((short)1, "Ethernet(10Mb)");
    public static final ArpHardwareType EXPERIMENTAL_ETHERNET = new ArpHardwareType((short)2, "ExperimentalEthernet(3Mb)");
    public static final ArpHardwareType FRAME_RELAY = new ArpHardwareType((short)15, "FrameRelay");
    public static final ArpHardwareType IPSEC_TUNNEL = new ArpHardwareType((short)31, "IPsec tunnel");
    private static final Map<Short, ArpHardwareType> registry = new HashMap<Short, ArpHardwareType>();

    public ArpHardwareType(Short value, String name) {
        super(value, name);
    }

    public static ArpHardwareType getInstance(Short value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new ArpHardwareType(value, "unknown");
    }

    public static ArpHardwareType register(ArpHardwareType type) {
        return registry.put((Short)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Short)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(Short o) {
        return ((Short)this.value()).compareTo(o);
    }

    static {
        for (Field field : ArpHardwareType.class.getFields()) {
            if (!ArpHardwareType.class.isAssignableFrom(field.getType())) continue;
            try {
                ArpHardwareType f = (ArpHardwareType)field.get(null);
                registry.put((Short)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

