/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.factory;

import org.pcap4j.packet.factory.PacketFactory;
import org.pcap4j.packet.factory.PacketFactoryBinder;
import org.pcap4j.packet.factory.SimplePacketFactoryBinder;
import org.pcap4j.packet.namednumber.NamedNumber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PacketFactories {
    private static final Logger logger = LoggerFactory.getLogger(PacketFactories.class);
    private static final PacketFactoryBinder FACTORY_BINDER;

    private PacketFactories() {
        throw new AssertionError();
    }

    public static <T, N extends NamedNumber<?>> PacketFactory<T, N> getFactory(Class<T> targetClass, Class<N> numberClass) {
        if (numberClass == null || targetClass == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("numberClass: ").append(numberClass).append(" targetClass: ").append(targetClass);
            throw new NullPointerException(sb.toString());
        }
        if (FACTORY_BINDER != null) {
            return FACTORY_BINDER.getPacketFactory(targetClass, numberClass);
        }
        return SimplePacketFactoryBinder.getInstance().getPacketFactory(targetClass, numberClass);
    }

    static {
        PacketFactoryBinder factoryBinder = null;
        try {
            factoryBinder = PacketFactoryBinder.getInstance();
            logger.info("Succeeded in FactoryBinder.getInstance()");
        }
        catch (NoClassDefFoundError e) {
            logger.warn(NoClassDefFoundError.class.getName() + ":" + e.getMessage());
        }
        catch (NoSuchMethodError e) {
            logger.warn(NoSuchMethodError.class.getName() + ":" + e.getMessage());
        }
        FACTORY_BINDER = factoryBinder;
    }
}

