/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.util.ByteArrays;

public final class Ssh2String
implements Serializable {
    private static final long serialVersionUID = -1591381991570120515L;
    private final int length;
    private final byte[] string;

    public Ssh2String(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData may not be null");
        }
        if (rawData.length < 4) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The rawData length must be more than 3. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.length = ByteArrays.getInt(rawData, 0);
        if (this.length < 0) {
            StringBuilder sb = new StringBuilder(120);
            sb.append("A name-list the length of which is longer than 2147483647 is not supported. length: ").append((long)this.length & 0xFFFFFFFFL);
            throw new IllegalRawDataException(sb.toString());
        }
        this.string = ByteArrays.getSubArray(rawData, 4, this.length);
    }

    public Ssh2String(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        try {
            this.string = str.getBytes("UTF-8");
            this.length = this.string.length;
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Never get here.");
        }
    }

    public static Ssh2String newInstance(byte[] str) {
        if (str == null) {
            throw new NullPointerException();
        }
        byte[] rawData = new byte[str.length + 4];
        System.arraycopy(ByteArrays.toByteArray(str.length), 0, rawData, 0, 4);
        System.arraycopy(str, 0, rawData, 4, str.length);
        return new Ssh2String(rawData);
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getString() {
        return ByteArrays.clone(this.string);
    }

    public String getStringAsString() {
        try {
            return new String(this.string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)"Never get here.");
        }
    }

    public int length() {
        return this.length + 4;
    }

    public byte[] getRawData() {
        byte[] rawData = new byte[this.length + 4];
        System.arraycopy(ByteArrays.toByteArray(this.length), 0, rawData, 0, 4);
        System.arraycopy(this.string, 0, rawData, 4, this.length);
        return rawData;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        sb.append(this.getStringAsString()).append(" (").append(ByteArrays.toHexString(this.string, " ")).append(")");
        return sb.toString();
    }
}

