/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Ssh2String;
import org.pcap4j.packet.namednumber.Ssh2MessageNumber;
import org.pcap4j.util.ByteArrays;

public final class Ssh2ServiceAcceptPacket
extends AbstractPacket {
    private static final long serialVersionUID = 6862963187041604290L;
    private final Ssh2ServiceAcceptHeader header;

    public static Ssh2ServiceAcceptPacket newPacket(byte[] rawData) {
        return new Ssh2ServiceAcceptPacket(rawData);
    }

    private Ssh2ServiceAcceptPacket(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException();
        }
        this.header = new Ssh2ServiceAcceptHeader(rawData);
    }

    private Ssh2ServiceAcceptPacket(Builder builder) {
        if (builder == null || builder.serviceName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.serviceName: ").append(builder.serviceName);
            throw new NullPointerException(sb.toString());
        }
        this.header = new Ssh2ServiceAcceptHeader(builder);
    }

    public Ssh2ServiceAcceptHeader getHeader() {
        return this.header;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Ssh2ServiceAcceptHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 8957656530972381650L;
        private final Ssh2MessageNumber messageNumber = Ssh2MessageNumber.SSH_MSG_SERVICE_ACCEPT;
        private final Ssh2String serviceName;

        private Ssh2ServiceAcceptHeader(byte[] rawData) {
            if (rawData.length < 5) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an SSH2 Service Accept header. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
            if (!Ssh2MessageNumber.getInstance(rawData[0]).equals(Ssh2MessageNumber.SSH_MSG_SERVICE_ACCEPT)) {
                StringBuilder sb = new StringBuilder(120);
                sb.append("The data is not an SSH2 Service Accept message. data: ").append(new String(rawData));
                throw new IllegalRawDataException(sb.toString());
            }
            this.serviceName = new Ssh2String(ByteArrays.getSubArray(rawData, 1));
        }

        private Ssh2ServiceAcceptHeader(Builder builder) {
            this.serviceName = builder.serviceName;
        }

        public Ssh2MessageNumber getMessageNumber() {
            return this.messageNumber;
        }

        public Ssh2String getServiceName() {
            return this.serviceName;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(new byte[]{(Byte)this.messageNumber.value()});
            rawFields.add(this.serviceName.getRawData());
            return rawFields;
        }

        @Override
        protected int calcLength() {
            return this.serviceName.length() + 1;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[SSH2 Service Accept Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Message Number: ").append(this.messageNumber).append(ls);
            sb.append("  service name: ").append(this.serviceName).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private Ssh2String serviceName;

        public Builder() {
        }

        private Builder(Ssh2ServiceAcceptPacket packet) {
            this.serviceName = packet.header.serviceName;
        }

        public Builder serviceName(Ssh2String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public Ssh2ServiceAcceptPacket build() {
            return new Ssh2ServiceAcceptPacket(this);
        }
    }
}

