/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV6EchoReplyPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -3713149118572340972L;
    private final IcmpV6EchoReplyHeader header;
    private final Packet payload;

    public static IcmpV6EchoReplyPacket newPacket(byte[] rawData) {
        return new IcmpV6EchoReplyPacket(rawData);
    }

    private IcmpV6EchoReplyPacket(byte[] rawData) {
        this.header = new IcmpV6EchoReplyHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), rawData.length - this.header.length());
        this.payload = UnknownPacket.newPacket(rawPayload);
    }

    private IcmpV6EchoReplyPacket(Builder builder) {
        super(builder);
        if (builder.payloadBuilder == null) {
            throw new NullPointerException("builder.payloadBuilder must not be null");
        }
        this.payload = builder.payloadBuilder.build();
        this.header = new IcmpV6EchoReplyHeader(builder);
    }

    public IcmpV6EchoReplyHeader getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV6EchoReplyHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = -5140524898291969262L;

        private IcmpV6EchoReplyHeader(byte[] rawData) {
            super(rawData);
        }

        private IcmpV6EchoReplyHeader(Builder builder) {
            super(builder);
        }

        protected String getHeaderName() {
            return "ICMPv6 Echo Reply Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV6EchoReplyPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload.getBuilder();
        }

        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public IcmpV6EchoReplyPacket build() {
            return new IcmpV6EchoReplyPacket(this);
        }
    }
}

