/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IcmpV4InvokingPacketPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4SourceQuenchPacket
extends IcmpV4InvokingPacketPacket {
    private static final long serialVersionUID = 5977981249980504735L;
    private final IcmpV4SourceQuenchHeader header;

    public static IcmpV4SourceQuenchPacket newPacket(byte[] rawData) {
        IcmpV4SourceQuenchHeader header = new IcmpV4SourceQuenchHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, header.length(), rawData.length - header.length());
        return new IcmpV4SourceQuenchPacket(header, rawPayload);
    }

    private IcmpV4SourceQuenchPacket(IcmpV4SourceQuenchHeader header, byte[] rawData) {
        super(rawData);
        this.header = header;
    }

    private IcmpV4SourceQuenchPacket(Builder builder) {
        super(builder);
        this.header = new IcmpV4SourceQuenchHeader(builder);
    }

    public IcmpV4SourceQuenchHeader getHeader() {
        return this.header;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class IcmpV4SourceQuenchHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = -3569475573220386469L;
        private static final int UNUSED_OFFSET = 0;
        private static final int UNUSED_SIZE = 4;
        private static final int ICMPV4_SOURCE_QUENCH_HEADER_SIZE = 4;
        private final int unused;

        private IcmpV4SourceQuenchHeader(byte[] rawData) {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(80);
                sb.append("The data is too short to build an ICMPv4 Source Quench Header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            this.unused = ByteArrays.getInt(rawData, 0);
        }

        private IcmpV4SourceQuenchHeader(Builder builder) {
            this.unused = builder.unused;
        }

        public int getUnused() {
            return this.unused;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray(this.unused));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[ICMPv4 Source Quench Header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Unused: ").append(this.unused).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends IcmpV4InvokingPacketPacket.Builder {
        private int unused;

        public Builder() {
        }

        private Builder(IcmpV4SourceQuenchPacket packet) {
            super(packet);
            this.unused = packet.getHeader().unused;
        }

        public Builder unused(int unused) {
            this.unused = unused;
            return this;
        }

        public Builder payload(Packet payload) {
            super.payload(payload);
            return this;
        }

        public IcmpV4SourceQuenchPacket build() {
            return new IcmpV4SourceQuenchPacket(this);
        }
    }
}

