/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4EchoReplyPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -7353440327689688935L;
    private final IcmpV4EchoReplyHeader header;
    private final Packet payload;

    public static IcmpV4EchoReplyPacket newPacket(byte[] rawData) {
        return new IcmpV4EchoReplyPacket(rawData);
    }

    private IcmpV4EchoReplyPacket(byte[] rawData) {
        this.header = new IcmpV4EchoReplyHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), rawData.length - this.header.length());
        this.payload = UnknownPacket.newPacket(rawPayload);
    }

    private IcmpV4EchoReplyPacket(Builder builder) {
        super(builder);
        if (builder.payloadBuilder == null) {
            throw new NullPointerException("builder.payloadBuilder must not be null");
        }
        this.payload = builder.payloadBuilder.build();
        this.header = new IcmpV4EchoReplyHeader(builder);
    }

    public IcmpV4EchoReplyHeader getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4EchoReplyHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = 8044479519522316613L;

        private IcmpV4EchoReplyHeader(byte[] rawData) {
            super(rawData);
        }

        private IcmpV4EchoReplyHeader(Builder builder) {
            super(builder);
        }

        protected String getHeaderName() {
            return "ICMPv4 Echo Reply Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV4EchoReplyPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload.getBuilder();
        }

        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public IcmpV4EchoReplyPacket build() {
            return new IcmpV4EchoReplyPacket(this);
        }
    }
}

