/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import org.pcap4j.packet.IcmpIdentifiablePacket;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.UnknownPacket;
import org.pcap4j.util.ByteArrays;

public final class IcmpV4EchoPacket
extends IcmpIdentifiablePacket {
    private static final long serialVersionUID = -122451430580609855L;
    private final IcmpV4EchoHeader header;
    private final Packet payload;

    public static IcmpV4EchoPacket newPacket(byte[] rawData) {
        return new IcmpV4EchoPacket(rawData);
    }

    private IcmpV4EchoPacket(byte[] rawData) {
        this.header = new IcmpV4EchoHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), rawData.length - this.header.length());
        this.payload = UnknownPacket.newPacket(rawPayload);
    }

    private IcmpV4EchoPacket(Builder builder) {
        super(builder);
        if (builder.payloadBuilder == null) {
            throw new NullPointerException("builder.payloadBuilder must not be null");
        }
        this.payload = builder.payloadBuilder.build();
        this.header = new IcmpV4EchoHeader(builder);
    }

    public IcmpV4EchoHeader getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public static final class IcmpV4EchoHeader
    extends IcmpIdentifiablePacket.IcmpIdentifiableHeader {
        private static final long serialVersionUID = -1302478674628547524L;

        private IcmpV4EchoHeader(byte[] rawData) {
            super(rawData);
        }

        private IcmpV4EchoHeader(Builder builder) {
            super(builder);
        }

        protected String getHeaderName() {
            return "ICMPv4 Echo Header";
        }
    }

    public static final class Builder
    extends IcmpIdentifiablePacket.Builder {
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(IcmpV4EchoPacket packet) {
            super(packet);
            this.payloadBuilder = packet.payload.getBuilder();
        }

        public Builder identifier(short identifier) {
            super.identifier(identifier);
            return this;
        }

        public Builder sequenceNumber(short sequenceNumber) {
            super.sequenceNumber(sequenceNumber);
            return this;
        }

        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public IcmpV4EchoPacket build() {
            return new IcmpV4EchoPacket(this);
        }
    }
}

