/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.util;

import java.io.Serializable;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pcap4j.packet.namednumber.Oui;
import org.pcap4j.util.ByteArrays;

public final class MacAddress
implements Serializable {
    private static final long serialVersionUID = 751211532491344621L;
    private static final Pattern HEX_PATTERN = Pattern.compile("([^0-9a-fA-F])");
    public static final MacAddress ETHER_BROADCAST_ADDRESS = MacAddress.getByAddress(new byte[]{-1, -1, -1, -1, -1, -1});
    public static final int SIZE_IN_BYTES = 6;
    private final byte[] address;

    private MacAddress(byte[] address) {
        this.address = address;
    }

    public static MacAddress getByAddress(byte[] address) {
        if (address.length != 6) {
            throw new IllegalArgumentException(ByteArrays.toHexString(address, ":") + " is invalid for address. The length must be " + 6);
        }
        byte[] copy = new byte[address.length];
        System.arraycopy(address, 0, copy, 0, copy.length);
        return new MacAddress(copy);
    }

    public static MacAddress getByName(String name) {
        Matcher m = HEX_PATTERN.matcher(name);
        m.find();
        return MacAddress.getByName(name, m.group(1));
    }

    public static MacAddress getByName(String name, String separator) {
        return MacAddress.getByAddress(ByteArrays.parseByteArray(name, separator));
    }

    public byte[] getAddress() {
        byte[] copy = new byte[this.address.length];
        System.arraycopy(this.address, 0, copy, 0, copy.length);
        return copy;
    }

    public Oui getOui() {
        return Oui.getInstance(ByteArrays.getInt(this.address, 0) >>> 8);
    }

    public boolean isUnicast() {
        return (this.address[0] & 1) == 0;
    }

    public boolean isGloballyUnique() {
        return (this.address[0] & 2) == 0;
    }

    public int length() {
        return this.address.length;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (byte b : this.address) {
            sb.append(String.format("%02x", b)).append(":");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MacAddress)) {
            return false;
        }
        return Arrays.equals(((MacAddress)obj).getAddress(), this.address);
    }

    public int hashCode() {
        return Arrays.hashCode(this.address);
    }
}

