/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UdpPort
extends NamedNumber<Short> {
    private static final long serialVersionUID = -7898348444366318292L;
    public static final UdpPort SNMP = new UdpPort((short)161, "SNMP");
    public static final UdpPort SNMP_TRAP = new UdpPort((short)162, "SNMP Trap");
    private static final Map<Short, UdpPort> registry = new HashMap<Short, UdpPort>();

    public UdpPort(Short value, String name) {
        super(value, name);
    }

    public static UdpPort getInstance(Short value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new UdpPort(value, "unknown");
    }

    public static UdpPort register(UdpPort port) {
        return registry.put((Short)port.value(), port);
    }

    @Override
    public String valueAsString() {
        return String.valueOf(0xFFFF & (Short)this.value());
    }

    @Override
    public int compareTo(Short o) {
        return ((Short)this.value()).compareTo(o);
    }

    static {
        for (Field field : UdpPort.class.getFields()) {
            if (!UdpPort.class.isAssignableFrom(field.getType())) continue;
            try {
                UdpPort f = (UdpPort)field.get(null);
                registry.put((Short)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

