/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataLinkType
extends NamedNumber<Integer> {
    private static final long serialVersionUID = -4299486028394578120L;
    public static final DataLinkType NULL = new DataLinkType(0, "Null");
    public static final DataLinkType EN10MB = new DataLinkType(1, "Ethernet");
    public static final DataLinkType IEEE802 = new DataLinkType(6, "Token Ring");
    public static final DataLinkType PPP = new DataLinkType(9, "PPP");
    public static final DataLinkType FDDI = new DataLinkType(10, "FDDI");
    public static final DataLinkType IEEE802_11 = new DataLinkType(105, "Wireless");
    public static final DataLinkType DOCSIS = new DataLinkType(143, "DOCSIS");
    private static final Map<Integer, DataLinkType> registry = new HashMap<Integer, DataLinkType>();

    public DataLinkType(Integer value, String name) {
        super(value, name);
    }

    public static DataLinkType getInstance(Integer value) {
        if (registry.containsKey(value)) {
            return registry.get(value);
        }
        return new DataLinkType(value, "unknown");
    }

    public static DataLinkType register(DataLinkType type) {
        return registry.put((Integer)type.value(), type);
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Integer)this.value() & 0xFFFF);
    }

    @Override
    public int compareTo(Integer o) {
        return ((Integer)this.value()).compareTo(o);
    }

    static {
        for (Field field : DataLinkType.class.getFields()) {
            if (!DataLinkType.class.isAssignableFrom(field.getType())) continue;
            try {
                DataLinkType f = (DataLinkType)field.get(null);
                registry.put((Integer)f.value(), f);
            }
            catch (IllegalArgumentException e) {
                throw new AssertionError((Object)e);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)e);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
        }
    }
}

