/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.net.Inet4Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.IpV4InternetTimestampOption;
import org.pcap4j.util.ByteArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IpV4InternetTimestampOptionAddressPrespecified
implements IpV4InternetTimestampOption.IpV4InternetTimestampOptionData {
    private static final long serialVersionUID = 3865517048348635723L;
    private final Inet4Address address;
    private final List<Integer> timestamps;

    public static IpV4InternetTimestampOptionAddressPrespecified newInstance(byte[] rawData) {
        return new IpV4InternetTimestampOptionAddressPrespecified(rawData);
    }

    private IpV4InternetTimestampOptionAddressPrespecified(byte[] rawData) {
        if (rawData == null) {
            throw new NullPointerException("rawData may not be null");
        }
        if (rawData.length % 4 != 0) {
            StringBuilder sb = new StringBuilder(100);
            sb.append("The raw data length must be an integer multiple of 4 octets long. rawData: ").append(ByteArrays.toHexString(rawData, " "));
            throw new IllegalRawDataException(sb.toString());
        }
        this.address = rawData.length != 0 ? ByteArrays.getInet4Address(rawData, 0) : null;
        this.timestamps = new ArrayList<Integer>();
        for (int i = 4; i < rawData.length; i += 4) {
            this.timestamps.add(ByteArrays.getInt(rawData, i));
        }
    }

    public IpV4InternetTimestampOptionAddressPrespecified(Inet4Address address, List<Integer> timestamps) {
        if (timestamps == null) {
            throw new NullPointerException("timestamps may not be null");
        }
        if (address == null && timestamps.size() != 0) {
            throw new IllegalArgumentException("timestamps.size() must be 0 if address is null");
        }
        this.address = address;
        this.timestamps = new ArrayList<Integer>(timestamps);
    }

    public Inet4Address getAddress() {
        return this.address;
    }

    public List<Integer> getTimestamps() {
        return new ArrayList<Integer>(this.timestamps);
    }

    @Override
    public int length() {
        if (this.address == null) {
            return 0;
        }
        return 4 + this.timestamps.size() * 4;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        Iterator<Integer> iter = this.timestamps.iterator();
        for (int i = 0; i < rawData.length; i += 4) {
            System.arraycopy(ByteArrays.toByteArray(iter.next()), 0, rawData, 0, 4);
        }
        return rawData;
    }

    public String toString() {
        if (this.address == null) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[address: ").append(this.address);
        sb.append("] [timestamps:");
        for (Integer ts : this.timestamps) {
            sb.append(" ").append((long)ts.intValue() & 0xFFFFFFFFL);
        }
        sb.append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        return Arrays.equals(((IpV4InternetTimestampOptionAddressPrespecified)this.getClass().cast(obj)).getRawData(), this.getRawData());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getRawData());
    }
}

