/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.ArrayList;
import java.util.List;
import org.pcap4j.packet.AbstractPacket;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.Packet;
import org.pcap4j.packet.factory.PacketFactories;
import org.pcap4j.packet.namednumber.EtherType;
import org.pcap4j.util.ByteArrays;

public final class Dot1qVlanTagPacket
extends AbstractPacket {
    private static final long serialVersionUID = 1522789079803339400L;
    private final Dot1qVlanTagHeader header;
    private final Packet payload;

    public static Dot1qVlanTagPacket newPacket(byte[] rawData) {
        return new Dot1qVlanTagPacket(rawData);
    }

    private Dot1qVlanTagPacket(byte[] rawData) {
        this.header = new Dot1qVlanTagHeader(rawData);
        byte[] rawPayload = ByteArrays.getSubArray(rawData, this.header.length(), rawData.length - this.header.length());
        this.payload = PacketFactories.getFactory(Packet.class, EtherType.class).newInstance(rawPayload, this.header.getType());
    }

    private Dot1qVlanTagPacket(Builder builder) {
        if (builder == null || builder.type == null || builder.payloadBuilder == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("builder: ").append(builder).append(" builder.type: ").append(builder.type).append(" builder.payloadBuilder: ").append(builder.payloadBuilder);
            throw new NullPointerException(sb.toString());
        }
        this.payload = builder.payloadBuilder.build();
        this.header = new Dot1qVlanTagHeader(builder);
    }

    public Dot1qVlanTagHeader getHeader() {
        return this.header;
    }

    public Packet getPayload() {
        return this.payload;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Dot1qVlanTagHeader
    extends AbstractPacket.AbstractHeader {
        private static final long serialVersionUID = 7130569411806479522L;
        private static final int PRIORITY_AND_CFI_AND_VID_OFFSET = 0;
        private static final int PRIORITY_AND_CFI_AND_VID_SIZE = 2;
        private static final int TYPE_OFFSET = 2;
        private static final int TYPE_SIZE = 2;
        private static final int DOT1Q_TAG_HEADER_SIZE = 4;
        private final byte priority;
        private final boolean cfi;
        private final short vid;
        private final EtherType type;

        private Dot1qVlanTagHeader(byte[] rawData) {
            if (rawData.length < 4) {
                StringBuilder sb = new StringBuilder(110);
                sb.append("The data is too short to build an IEEE802.1Q Tag header(").append(4).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " "));
                throw new IllegalRawDataException(sb.toString());
            }
            short priorityAndCfiAndVid = ByteArrays.getShort(rawData, 0);
            this.priority = (byte)((priorityAndCfiAndVid & 0xE000) >> 13);
            this.cfi = (priorityAndCfiAndVid & 0x1000) >> 12 == 1;
            this.vid = (byte)(priorityAndCfiAndVid & 0xFFF);
            this.type = EtherType.getInstance(ByteArrays.getShort(rawData, 2));
        }

        private Dot1qVlanTagHeader(Builder builder) {
            if ((builder.priority & 0xF8) != 0) {
                throw new IllegalArgumentException("invalid priority: " + builder.priority);
            }
            if ((builder.vid & 0xF000) != 0) {
                throw new IllegalArgumentException("invalid vid: " + builder.vid);
            }
            this.priority = builder.priority;
            this.cfi = builder.cfi;
            this.vid = builder.vid;
            this.type = builder.type;
        }

        public byte getPriority() {
            return this.priority;
        }

        public boolean getCfi() {
            return this.cfi;
        }

        public short getVid() {
            return this.vid;
        }

        public int getVidAsInt() {
            return 0xFFF & this.vid;
        }

        public EtherType getType() {
            return this.type;
        }

        @Override
        protected List<byte[]> getRawFields() {
            ArrayList<byte[]> rawFields = new ArrayList<byte[]>();
            rawFields.add(ByteArrays.toByteArray((short)(this.priority << 13 | (this.cfi ? 1 : 0) << 12 | this.vid)));
            rawFields.add(ByteArrays.toByteArray((Short)this.type.value()));
            return rawFields;
        }

        @Override
        public int length() {
            return 4;
        }

        @Override
        protected String buildString() {
            StringBuilder sb = new StringBuilder();
            String ls = System.getProperty("line.separator");
            sb.append("[IEEE802.1Q Tag header (").append(this.length()).append(" bytes)]").append(ls);
            sb.append("  Priority: ").append(this.priority).append(ls);
            sb.append("  CFI: ").append(this.cfi ? 1 : 0).append(ls);
            sb.append("  VID: ").append(this.getVidAsInt()).append(ls);
            sb.append("  Type: ").append(this.type).append(ls);
            return sb.toString();
        }
    }

    public static final class Builder
    extends AbstractPacket.AbstractBuilder {
        private byte priority;
        private boolean cfi;
        private short vid;
        private EtherType type;
        private Packet.Builder payloadBuilder;

        public Builder() {
        }

        private Builder(Dot1qVlanTagPacket packet) {
            this.priority = packet.header.priority;
            this.cfi = packet.header.cfi;
            this.vid = packet.header.vid;
            this.type = packet.header.type;
            this.payloadBuilder = packet.payload.getBuilder();
        }

        public Builder priority(byte priority) {
            this.priority = priority;
            return this;
        }

        public Builder cfi(boolean cfi) {
            this.cfi = cfi;
            return this;
        }

        public Builder vid(short vid) {
            this.vid = vid;
            return this;
        }

        public Builder type(EtherType type) {
            this.type = type;
            return this;
        }

        public Builder payloadBuilder(Packet.Builder payloadBuilder) {
            this.payloadBuilder = payloadBuilder;
            return this;
        }

        public Packet.Builder getPayloadBuilder() {
            return this.payloadBuilder;
        }

        public Dot1qVlanTagPacket build() {
            return new Dot1qVlanTagPacket(this);
        }
    }
}

