/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.core;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pcap4j.core.BpfProgram;
import org.pcap4j.core.Inets;
import org.pcap4j.core.NativeMappings;
import org.pcap4j.core.PcapAddress;
import org.pcap4j.core.PcapHandle;
import org.pcap4j.core.PcapNativeException;
import org.pcap4j.core.PcapNetworkInterface;
import org.pcap4j.packet.namednumber.DataLinkType;
import org.pcap4j.util.ByteArrays;
import org.pcap4j.util.Inet4NetworkAddress;
import org.pcap4j.util.MacAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Pcaps {
    private static final Logger logger = LoggerFactory.getLogger(Pcaps.class);

    private Pcaps() {
        throw new AssertionError();
    }

    public static List<PcapNetworkInterface> findAllDevs() throws PcapNativeException {
        Pointer alldevsp;
        PointerByReference alldevsPP = new PointerByReference();
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        int rc = NativeMappings.pcap_findalldevs(alldevsPP, errbuf);
        if (rc != 0) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("Return code: ").append(rc).append(", Message: ").append((Object)errbuf);
            throw new PcapNativeException(sb.toString(), rc);
        }
        if (errbuf.length() != 0) {
            logger.warn("{}", (Object)errbuf);
        }
        if ((alldevsp = alldevsPP.getValue()) == null) {
            logger.info("No NIF was found.");
            return Collections.emptyList();
        }
        NativeMappings.pcap_if pcapIf = new NativeMappings.pcap_if(alldevsp);
        ArrayList<PcapNetworkInterface> ifList = new ArrayList<PcapNetworkInterface>();
        NativeMappings.pcap_if pif = pcapIf;
        while (pif != null) {
            ifList.add(PcapNetworkInterface.newInstance(pif, true));
            pif = pif.next;
        }
        NativeMappings.pcap_freealldevs(pcapIf.getPointer());
        logger.info("{} NIF(s) found.", (Object)ifList.size());
        return ifList;
    }

    public static PcapNetworkInterface getDevByAddress(InetAddress addr) throws PcapNativeException {
        if (addr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("addr: ").append(addr);
            throw new NullPointerException(sb.toString());
        }
        List<PcapNetworkInterface> allDevs = Pcaps.findAllDevs();
        for (PcapNetworkInterface pif : allDevs) {
            for (PcapAddress paddr : pif.getAddresses()) {
                if (!paddr.getAddress().equals(addr)) continue;
                return pif;
            }
        }
        return null;
    }

    public static PcapNetworkInterface getDevByName(String name) throws PcapNativeException {
        if (name == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("name: ").append(name);
            throw new NullPointerException(sb.toString());
        }
        List<PcapNetworkInterface> allDevs = Pcaps.findAllDevs();
        for (PcapNetworkInterface pif : allDevs) {
            if (!pif.getName().equals(name)) continue;
            return pif;
        }
        return null;
    }

    public static String lookupDev() throws PcapNativeException {
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Pointer result = NativeMappings.pcap_lookupdev(errbuf);
        if (result == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        return result.getString(0L, true);
    }

    public static Inet4NetworkAddress lookupNet(String devName) throws PcapNativeException {
        if (devName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("devName: ").append(devName);
            throw new NullPointerException(sb.toString());
        }
        IntByReference netp = new IntByReference();
        IntByReference maskp = new IntByReference();
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        int rc = NativeMappings.pcap_lookupnet(devName, netp, maskp, errbuf);
        if (rc < 0) {
            throw new PcapNativeException(errbuf.toString(), rc);
        }
        int net = netp.getValue();
        int mask = maskp.getValue();
        return new Inet4NetworkAddress(Inets.itoInetAddress(net), Inets.itoInetAddress(mask));
    }

    public static PcapHandle openOffline(String filePath) throws PcapNativeException {
        if (filePath == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("filePath: ").append(filePath);
            throw new NullPointerException(sb.toString());
        }
        NativeMappings.PcapErrbuf errbuf = new NativeMappings.PcapErrbuf();
        Pointer handle = NativeMappings.pcap_open_offline(filePath, errbuf);
        if (handle == null || errbuf.length() != 0) {
            throw new PcapNativeException(errbuf.toString());
        }
        return new PcapHandle(handle);
    }

    public static PcapHandle openDead(DataLinkType dlt, int maxCaptureLength) throws PcapNativeException {
        if (dlt == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("dlt: ").append(dlt);
            throw new NullPointerException(sb.toString());
        }
        Pointer handle = NativeMappings.pcap_open_dead((Integer)dlt.value(), maxCaptureLength);
        if (handle == null) {
            StringBuilder sb = new StringBuilder(50);
            sb.append("Failed to open a PcapHandle. dlt: ").append(dlt).append(" maxCaptureLength: ").append(maxCaptureLength);
            throw new PcapNativeException(sb.toString());
        }
        return new PcapHandle(handle);
    }

    public static BpfProgram compileFilter(int snaplen, DataLinkType dlt, String bpfExpression, BpfProgram.BpfCompileMode mode, Inet4Address netmask) throws PcapNativeException {
        if (dlt == null || bpfExpression == null || mode == null || netmask == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("dlt: ").append(dlt).append(" bpfExpression: ").append(bpfExpression).append(" mode: ").append((Object)mode).append(" netmask: ").append(netmask);
            throw new NullPointerException(sb.toString());
        }
        NativeMappings.bpf_program prog = new NativeMappings.bpf_program();
        int rc = NativeMappings.pcap_compile_nopcap(snaplen, (Integer)dlt.value(), prog, bpfExpression, mode.getValue(), ByteArrays.getInt(ByteArrays.toByteArray(netmask), 0));
        if (rc < 0) {
            throw new PcapNativeException("Failed to compile the BPF expression: " + bpfExpression, rc);
        }
        return new BpfProgram(prog, bpfExpression);
    }

    public static DataLinkType dataLinkNameToVal(String name) throws PcapNativeException {
        if (name == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("name: ").append(name);
            throw new NullPointerException(sb.toString());
        }
        int rc = NativeMappings.pcap_datalink_name_to_val(name);
        if (rc < 0) {
            throw new PcapNativeException("Failed to convert the data link name to the value: " + name, rc);
        }
        return DataLinkType.getInstance(rc);
    }

    public static String dataLinkTypeToName(DataLinkType dlt) throws PcapNativeException {
        if (dlt == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("dlt: ").append(dlt);
            throw new NullPointerException(sb.toString());
        }
        return Pcaps.dataLinkValToName((Integer)dlt.value());
    }

    public static String dataLinkValToName(int dataLinkVal) throws PcapNativeException {
        String name = NativeMappings.pcap_datalink_val_to_name(dataLinkVal);
        if (name == null) {
            throw new PcapNativeException("Failed to convert the data link value to the name: " + dataLinkVal);
        }
        return name;
    }

    public static String dataLinkTypeToDescription(DataLinkType dlt) throws PcapNativeException {
        if (dlt == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("dlt: ").append(dlt);
            throw new NullPointerException(sb.toString());
        }
        return Pcaps.dataLinkValToDescription((Integer)dlt.value());
    }

    public static String dataLinkValToDescription(int dataLinkVal) throws PcapNativeException {
        String descr = NativeMappings.pcap_datalink_val_to_description(dataLinkVal);
        if (descr == null) {
            throw new PcapNativeException("Failed to convert the data link value to the description: " + dataLinkVal);
        }
        return descr;
    }

    public static String strError(int error) {
        return NativeMappings.pcap_strerror(error).getString(0L);
    }

    public static String libVersion() {
        return NativeMappings.pcap_lib_version();
    }

    public static String toBpfString(InetAddress inetAddr) {
        if (inetAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("inetAddr: ").append(inetAddr);
            throw new NullPointerException(sb.toString());
        }
        String strAddr = inetAddr.toString();
        return strAddr.substring(strAddr.lastIndexOf("/") + 1);
    }

    public static String toBpfString(MacAddress macAddr) {
        if (macAddr == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("macAddr: ").append(macAddr);
            throw new NullPointerException(sb.toString());
        }
        StringBuffer buf = new StringBuffer();
        byte[] address = macAddr.getAddress();
        for (int i = 0; i < address.length; ++i) {
            buf.append(String.format("%02x", address[i]));
            buf.append(":");
        }
        buf.deleteCharAt(buf.length() - 1);
        return buf.toString();
    }
}

