/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.simpletostring;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CDefaultValue;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.codegenerator.AbstractCodeGeneratorPlugin;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerator;
import org.jvnet.jaxb2_commons.plugin.simpletostring.ToStringArguments;
import org.jvnet.jaxb2_commons.plugin.simpletostring.ToStringCodeGenerator;
import org.jvnet.jaxb2_commons.plugin.tostring.Customizations;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.FieldUtils;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;

public class SimpleToStringPlugin
extends AbstractCodeGeneratorPlugin<ToStringArguments> {
    private static final String CONTENT_START = "[";
    private static final String CONTENT_END = "]";
    private static final String FIELD_SEPARATOR = ", ";
    private boolean fullClassName = false;
    private boolean showFieldNames = false;
    private boolean showChildItems = false;

    public String getOptionName() {
        return "XsimpleToString";
    }

    public String getUsage() {
        return "  -XsimpleToString   :  generate reflection-free runtime-free 'toString' methods";
    }

    @Override
    protected QName getSpecialIgnoredElementName() {
        return Customizations.IGNORED_ELEMENT_NAME;
    }

    public boolean isFullClassName() {
        return this.fullClassName;
    }

    public void setFullClassName(boolean fullClassName) {
        this.fullClassName = fullClassName;
    }

    public boolean isShowFieldNames() {
        return this.showFieldNames;
    }

    public void setShowFieldNames(boolean showFieldNames) {
        this.showFieldNames = showFieldNames;
    }

    public boolean isShowChildItems() {
        return this.showChildItems;
    }

    public void setShowChildItems(boolean showChildItems) {
        this.showChildItems = showChildItems;
    }

    @Override
    protected CodeGenerator<ToStringArguments> createCodeGenerator(JCodeModel codeModel) {
        return new ToStringCodeGenerator(codeModel);
    }

    @Override
    protected void generate(ClassOutline classOutline, JDefinedClass theClass) {
        JMethod toStringFieldsMethod = this.generateToStringFieldsMethod(classOutline, theClass);
        this.generateToStringMethod(theClass, toStringFieldsMethod);
    }

    private void generateToStringMethod(JDefinedClass theClass, JMethod toStringFieldsMethod) {
        JCodeModel codeModel = theClass.owner();
        JMethod toStringMethod = theClass.method(1, (JType)codeModel.ref(String.class), "toString");
        toStringMethod.annotate(Override.class);
        JBlock body = toStringMethod.body();
        JVar stringBuilder = body.decl(8, (JType)codeModel.ref(StringBuilder.class), "stringBuilder", (JExpression)JExpr._new((JClass)codeModel.ref(StringBuilder.class)));
        if (this.isFullClassName()) {
            body.add((JStatement)stringBuilder.invoke("append").arg((JExpression)JExpr._this().invoke("getClass").invoke("getName")));
        } else {
            body.add((JStatement)stringBuilder.invoke("append").arg((JExpression)JExpr._this().invoke("getClass").invoke("getSimpleName")));
        }
        body.add((JStatement)stringBuilder.invoke("append").arg(JExpr.lit((char)'@')));
        body.add((JStatement)stringBuilder.invoke("append").arg((JExpression)codeModel.ref(Integer.class).staticInvoke("toHexString").arg((JExpression)codeModel.ref(System.class).staticInvoke("identityHashCode").arg(JExpr._this()))));
        body.add((JStatement)stringBuilder.invoke("append").arg(JExpr.lit((String)CONTENT_START)));
        body.invoke(toStringFieldsMethod.name()).arg((JExpression)stringBuilder);
        body.add((JStatement)stringBuilder.invoke("append").arg(JExpr.lit((String)CONTENT_END)));
        body._return((JExpression)stringBuilder.invoke("toString"));
    }

    private JMethod generateToStringFieldsMethod(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod toStringFieldsMethod = theClass.method(2, (JType)codeModel.VOID, "toStringFields");
        toStringFieldsMethod.param((JType)codeModel.ref(StringBuilder.class), "stringBuilder");
        JVar stringBuilder = (JVar)toStringFieldsMethod.params().get(0);
        JBlock body = toStringFieldsMethod.body();
        String fieldSeparator = null;
        if (StrategyClassUtils.superClassNotIgnored(classOutline, this.getIgnoring()) != null) {
            body.add((JStatement)JExpr._super().invoke(toStringFieldsMethod.name()).arg((JExpression)stringBuilder));
            fieldSeparator = FIELD_SEPARATOR;
        }
        if ((declaredFields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())).length > 0) {
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
                if (fieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                String propertyName = fieldOutline.getPropertyInfo().getName(true);
                JVar value = block.decl(fieldAccessor.getType(), "the" + propertyName);
                fieldAccessor.toRawValue(block, value);
                JType exposedType = fieldAccessor.getType();
                JExpression hasSetValue = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
                String fieldName = null;
                if (this.isShowFieldNames()) {
                    fieldName = fieldOutline.getPropertyInfo().getName(false);
                }
                CPropertyInfo propertyInfo = fieldAccessor.getPropertyInfo();
                CDefaultValue defaultValue = propertyInfo.defaultValue;
                ToStringArguments arguments = new ToStringArguments(codeModel, stringBuilder, value, hasSetValue, fieldSeparator, fieldName, this.isShowChildItems(), defaultValue != null);
                Set possibleTypes = FieldUtils.getPossibleTypes((FieldOutline)fieldOutline, (Aspect)Aspect.EXPOSED);
                boolean isAlwaysSet = fieldAccessor.isAlwaysSet();
                this.getCodeGenerator().generate(block, exposedType, possibleTypes, isAlwaysSet, arguments);
                fieldSeparator = FIELD_SEPARATOR;
            }
        }
        return toStringFieldsMethod;
    }
}

