/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.jaxb2_commons.plugin.simpleequals;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.jaxb2_commons.plugin.codegenerator.AbstractCodeGeneratorPlugin;
import org.jvnet.jaxb2_commons.plugin.codegenerator.CodeGenerator;
import org.jvnet.jaxb2_commons.plugin.equals.Customizations;
import org.jvnet.jaxb2_commons.plugin.simpleequals.EqualsArguments;
import org.jvnet.jaxb2_commons.plugin.simpleequals.EqualsCodeGenerator;
import org.jvnet.jaxb2_commons.plugin.util.FieldOutlineUtils;
import org.jvnet.jaxb2_commons.plugin.util.StrategyClassUtils;
import org.jvnet.jaxb2_commons.util.FieldUtils;
import org.jvnet.jaxb2_commons.xjc.outline.FieldAccessorEx;

public class SimpleEqualsPlugin
extends AbstractCodeGeneratorPlugin<EqualsArguments> {
    public String getOptionName() {
        return "XsimpleEquals";
    }

    public String getUsage() {
        return "  -XsimpleEquals     :  generate reflection-free runtime-free 'equals' methods";
    }

    @Override
    protected QName getSpecialIgnoredElementName() {
        return Customizations.IGNORED_ELEMENT_NAME;
    }

    @Override
    protected CodeGenerator<EqualsArguments> createCodeGenerator(JCodeModel codeModel) {
        return new EqualsCodeGenerator(codeModel);
    }

    @Override
    protected void generate(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod objectEquals = theClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        objectEquals.annotate(Override.class);
        JVar object = objectEquals.param(Object.class, "object");
        JBlock body = objectEquals.body();
        JExpression objectIsNull = object.eq(JExpr._null());
        JExpression notTheSameType = JExpr._this().invoke("getClass").ne((JExpression)object.invoke("getClass"));
        body._if(JOp.cor((JExpression)objectIsNull, (JExpression)notTheSameType))._then()._return(JExpr.FALSE);
        body._if(JExpr._this().eq((JExpression)object))._then()._return(JExpr.TRUE);
        Boolean superClassNotIgnored = StrategyClassUtils.superClassNotIgnored(classOutline, this.getIgnoring());
        if (superClassNotIgnored != null) {
            body._if(JOp.not((JExpression)JExpr._super().invoke("equals").arg((JExpression)object)))._then()._return(JExpr.FALSE);
        }
        JExpression _this = JExpr._this();
        FieldOutline[] fields = FieldOutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        if (fields.length > 0) {
            JVar _that = body.decl(8, (JType)theClass, "that", (JExpression)JExpr.cast((JType)theClass, (JExpression)object));
            for (FieldOutline fieldOutline : fields) {
                FieldAccessorEx leftFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, _this);
                FieldAccessorEx rightFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)_that);
                if (leftFieldAccessor.isConstant() || rightFieldAccessor.isConstant()) continue;
                JBlock block = body.block();
                String name = fieldOutline.getPropertyInfo().getName(true);
                JType type = leftFieldAccessor.getType();
                JVar leftValue = block.decl(type, "left" + name);
                leftFieldAccessor.toRawValue(block, leftValue);
                JVar rightValue = block.decl(rightFieldAccessor.getType(), "right" + name);
                rightFieldAccessor.toRawValue(block, rightValue);
                JType exposedType = leftFieldAccessor.getType();
                Set possibleTypes = FieldUtils.getPossibleTypes((FieldOutline)fieldOutline, (Aspect)Aspect.EXPOSED);
                boolean isAlwaysSet = leftFieldAccessor.isAlwaysSet();
                JExpression leftHasSetValue = leftFieldAccessor.isAlwaysSet() || leftFieldAccessor.hasSetValue() == null ? JExpr.TRUE : leftFieldAccessor.hasSetValue();
                JExpression rightHasSetValue = rightFieldAccessor.isAlwaysSet() || rightFieldAccessor.hasSetValue() == null ? JExpr.TRUE : rightFieldAccessor.hasSetValue();
                this.getCodeGenerator().generate(block, exposedType, possibleTypes, isAlwaysSet, new EqualsArguments(codeModel, leftValue, leftHasSetValue, rightValue, rightHasSetValue));
            }
        }
        body._return(JExpr.TRUE);
    }
}

