/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import org.jvnet.basicjaxb.lang.VetoStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultVetoStrategy
implements VetoStrategy {
    private static final DefaultVetoStrategy INSTANCE = new DefaultVetoStrategy();
    private Logger logger = LoggerFactory.getLogger(VetoStrategy.class);

    public static DefaultVetoStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public void warn(String message, Object ... args) {
        this.getLogger().warn(message, args);
    }

    public void error(String message, Object ... args) {
        this.getLogger().warn(message, args);
    }

    @Override
    public boolean vetoPropertyChange(PropertyChangeEvent event, PropertyVetoException ex) {
        if (this.getLogger().isWarnEnabled()) {
            this.warn("Change vetoed of {} from {} to {} for {}", event.getPropertyName(), event.getOldValue(), event.getNewValue(), event.getSource());
        } else {
            this.error("Change vetoed of {} from {} to {} for {}", event.getPropertyName(), event.getOldValue(), event.getNewValue(), event.getSource(), ex);
        }
        return false;
    }
}

