/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.lang;

import org.jvnet.basicjaxb.lang.HashCode;
import org.jvnet.basicjaxb.lang.HashCodeStrategy;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.locator.RootObjectLocator;
import org.jvnet.basicjaxb.locator.util.LocatorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHashCodeStrategy
implements HashCodeStrategy {
    private static final DefaultHashCodeStrategy INSTANCE = new DefaultHashCodeStrategy();
    private Logger logger = LoggerFactory.getLogger(HashCodeStrategy.class);
    private int iConstant;

    public static DefaultHashCodeStrategy getInstance() {
        return INSTANCE;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.getLogger().isTraceEnabled();
    }

    public void debug(String message) {
        this.getLogger().debug(message);
    }

    public void trace(String message) {
        this.getLogger().trace(message);
    }

    protected int observe(ObjectLocator locator, int hash) {
        return this.observe("HASH", locator, hash);
    }

    protected int observe(String label, ObjectLocator locator, int hash) {
        if (this.isTraceEnabled()) {
            this.trace(this.buildMessage(label, locator, Integer.toHexString(hash)));
        } else if (this.isDebugEnabled() && locator instanceof RootObjectLocator) {
            this.debug(this.buildMessage(label, locator, Integer.toHexString(hash)));
        }
        return hash;
    }

    protected String buildMessage(String label, ObjectLocator locator, String value) {
        String message = locator != null ? label + ": {" + locator.getPathAsString() + "} -> " + value : label + ": {} -> " + value;
        return message;
    }

    public DefaultHashCodeStrategy() {
        this.iConstant = 37;
    }

    public DefaultHashCodeStrategy(int multiplierNonZeroOddNumber) {
        if (multiplierNonZeroOddNumber == 0) {
            throw new IllegalArgumentException("HashCodeStrategy requires a non zero multiplier.");
        }
        if (multiplierNonZeroOddNumber % 2 == 0) {
            throw new IllegalArgumentException("HashCodeStrategy requires an odd multiplier.");
        }
        this.iConstant = multiplierNonZeroOddNumber;
    }

    protected int hashCode(ObjectLocator locator, int hashCode, Object object) {
        if (object == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        if (!object.getClass().isArray()) {
            return this.hashCodeInternal(locator, hashCode, object);
        }
        if (object instanceof long[]) {
            return this.hashCode(locator, hashCode, (long[])object);
        }
        if (object instanceof int[]) {
            return this.hashCode(locator, hashCode, (int[])object);
        }
        if (object instanceof short[]) {
            return this.hashCode(locator, hashCode, (short[])object);
        }
        if (object instanceof char[]) {
            return this.hashCode(locator, hashCode, (char[])object);
        }
        if (object instanceof byte[]) {
            return this.hashCode(locator, hashCode, (byte[])object);
        }
        if (object instanceof double[]) {
            return this.hashCode(locator, hashCode, (double[])object);
        }
        if (object instanceof float[]) {
            return this.hashCode(locator, hashCode, (float[])object);
        }
        if (object instanceof boolean[]) {
            return this.hashCode(locator, hashCode, (boolean[])object);
        }
        if (object instanceof HashCode[]) {
            return this.hashCodeInternal(locator, hashCode, (HashCode[])object);
        }
        if (object instanceof Enum[]) {
            return this.hashCodeInternal(locator, hashCode, (Enum[])object);
        }
        return this.hashCode(locator, hashCode, (Object[])object);
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Object value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        if (value instanceof HashCode) {
            return this.hashCodeInternal(locator, hashCode, (HashCode)value);
        }
        if (value instanceof Enum) {
            return this.hashCodeInternal(locator, hashCode, (Enum)value);
        }
        return this.observe(locator, hashCode * this.iConstant + value.hashCode());
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Enum<?> value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        if (value instanceof HashCode) {
            return this.hashCodeInternal(locator, hashCode, (HashCode)((Object)value));
        }
        return this.observe(locator, hashCode * this.iConstant + value.hashCode());
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, HashCode object) {
        if (object == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        return this.observe(locator, hashCode * this.iConstant + object.hashCode(locator, this));
    }

    protected int hashCode(ObjectLocator locator, int hashCode, Object[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode * this.iConstant + 1;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, Enum<?>[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode * this.iConstant + 1;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCodeInternal((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCodeInternal(ObjectLocator locator, int hashCode, HashCode[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode * this.iConstant + 1;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCodeInternal((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, boolean value) {
        return this.observe(locator, hashCode * this.iConstant + (value ? 0 : 1));
    }

    protected int hashCode(ObjectLocator locator, int hashCode, byte value) {
        return this.observe(locator, hashCode * this.iConstant + value);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, char value) {
        return this.observe(locator, hashCode * this.iConstant + value);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, double value) {
        return this.hashCode(locator, hashCode, Double.doubleToLongBits(value));
    }

    protected int hashCode(ObjectLocator locator, int hashCode, float value) {
        return this.hashCode(locator, hashCode, Float.floatToIntBits(value));
    }

    protected int hashCode(ObjectLocator locator, int hashCode, int value) {
        return this.observe(locator, hashCode * this.iConstant + value);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, long value) {
        return this.observe(locator, hashCode * this.iConstant + (int)(value ^ value >> 32));
    }

    protected int hashCode(ObjectLocator locator, int hashCode, short value) {
        return this.observe(locator, hashCode * this.iConstant + value);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, boolean[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, byte[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, char[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, double[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, float[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, int[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, long[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    protected int hashCode(ObjectLocator locator, int hashCode, short[] value) {
        if (value == null) {
            return this.observe(locator, hashCode * this.iConstant);
        }
        int currentHashCode = hashCode;
        for (int i = 0; i < value.length; ++i) {
            currentHashCode = this.hashCode((ObjectLocator)LocatorUtils.item(locator, i, value[i]), currentHashCode, value[i]);
        }
        return this.observe(locator, currentHashCode);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, boolean value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, byte value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, char value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, double value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, float value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, int value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, long value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, short value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, Object value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, boolean[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, byte[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, char[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, double[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, float[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, int[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, long[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, short[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }

    @Override
    public int hashCode(ObjectLocator locator, int hashCode, Object[] value, boolean valueSet) {
        return valueSet ? this.hashCode(locator, hashCode * this.iConstant, value) : this.observe(locator, hashCode * this.iConstant + 1);
    }
}

