/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.simpleequals;

import com.sun.codemodel.JBlock;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JOp;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.Aspect;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.codegenerator.AbstractCodeGeneratorPlugin;
import org.jvnet.basicjaxb.plugin.codegenerator.CodeGenerator;
import org.jvnet.basicjaxb.plugin.equals.Customizations;
import org.jvnet.basicjaxb.plugin.simpleequals.EqualsArguments;
import org.jvnet.basicjaxb.plugin.simpleequals.EqualsCodeGenerator;
import org.jvnet.basicjaxb.plugin.util.AttributeWildcardArguments;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.FieldUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class SimpleEqualsPlugin
extends AbstractCodeGeneratorPlugin<EqualsArguments> {
    private static final String OPTION_NAME = "XsimpleEquals";
    private static final String OPTION_DESC = "generate reflection-free runtime-free 'equals' methods";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    @Override
    protected QName getSpecialIgnoredElementName() {
        return Customizations.IGNORED_ELEMENT_NAME;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    @Override
    protected CodeGenerator<EqualsArguments> createCodeGenerator(JCodeModel codeModel) {
        return new EqualsCodeGenerator(codeModel);
    }

    @Override
    protected void generate(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod objectEquals = theClass.method(1, (JType)codeModel.BOOLEAN, "equals");
        objectEquals.annotate(Override.class);
        JBlock body = objectEquals.body();
        JVar object = objectEquals.param(Object.class, "object");
        JExpression objectIsNull = object.eq(JExpr._null());
        JExpression notTheSameType = JExpr._this().invoke("getClass").ne((JExpression)object.invoke("getClass"));
        body._if(JOp.cor((JExpression)objectIsNull, (JExpression)notTheSameType))._then()._return(JExpr.FALSE);
        body._if(JExpr._this().eq((JExpression)object))._then()._return(JExpr.TRUE);
        Boolean superClassNotIgnored = StrategyClassUtils.superClassNotIgnored(classOutline, this.getIgnoring());
        if (superClassNotIgnored != null) {
            body._if(JOp.not((JExpression)JExpr._super().invoke("equals").arg((JExpression)object)))._then()._return(JExpr.FALSE);
        }
        JExpression _this = JExpr._this();
        FieldOutline[] declaredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring());
        if (declaredFields.length > 0 || classOutline.target.declaresAttributeWildcard()) {
            JVar _that = body.decl(8, (JType)theClass, "that", (JExpression)JExpr.cast((JType)theClass, (JExpression)object));
            for (FieldOutline fieldOutline : declaredFields) {
                FieldAccessorEx lhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, _this);
                FieldAccessorEx rhsFieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, (JExpression)_that);
                CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
                if (!lhsFieldAccessor.isConstant() && !rhsFieldAccessor.isConstant()) {
                    JBlock block = body.block();
                    String propertyName = fieldInfo.getName(true);
                    JType lhsExposedType = lhsFieldAccessor.getType();
                    JVar lhsValue = block.decl(lhsExposedType, "lhs" + propertyName);
                    lhsFieldAccessor.toRawValue(block, lhsValue);
                    JType rhsExposedType = rhsFieldAccessor.getType();
                    JVar rhsValue = block.decl(rhsExposedType, "rhs" + propertyName);
                    rhsFieldAccessor.toRawValue(block, rhsValue);
                    JExpression lhsHasSetValue = lhsFieldAccessor.isAlwaysSet() || lhsFieldAccessor.hasSetValue() == null ? JExpr.TRUE : lhsFieldAccessor.hasSetValue();
                    JExpression rhsHasSetValue = rhsFieldAccessor.isAlwaysSet() || rhsFieldAccessor.hasSetValue() == null ? JExpr.TRUE : rhsFieldAccessor.hasSetValue();
                    EqualsArguments arguments = new EqualsArguments(codeModel, lhsValue, lhsHasSetValue, rhsValue, rhsHasSetValue);
                    Set possibleTypes = FieldUtils.getPossibleTypes((FieldOutline)fieldOutline, (Aspect)Aspect.EXPOSED);
                    boolean isAlwaysSet = lhsFieldAccessor.isAlwaysSet();
                    this.getCodeGenerator().generate(block, lhsExposedType, possibleTypes, isAlwaysSet, arguments);
                }
                this.trace("{}, generate; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldInfo.getName(false)});
            }
            if (classOutline.target.declaresAttributeWildcard()) {
                AttributeWildcardArguments awa = new AttributeWildcardArguments(classOutline);
                JBlock block = body.block();
                JVar lhsValue = awa.fieldVar(block, _this, "lhs");
                JVar rhsValue = awa.fieldVar(block, (JExpression)_that, "rhs");
                EqualsArguments arguments = new EqualsArguments(codeModel, lhsValue, AttributeWildcardArguments.HAS_SET_VALUE, rhsValue, AttributeWildcardArguments.HAS_SET_VALUE);
                this.getCodeGenerator().generate(block, awa.getExposedType(), awa.getPossibleTypes(), true, arguments);
                this.trace("{}, generate; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((ClassOutline)classOutline), theClass.name(), "otherAttributes"});
            }
        }
        body._return(JExpr.TRUE);
        this.debug("{}, generate; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
    }
}

