/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.tostring;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.lang.JAXBToStringStrategy;
import org.jvnet.basicjaxb.lang.ToString;
import org.jvnet.basicjaxb.lang.ToStringStrategy;
import org.jvnet.basicjaxb.locator.DefaultRootObjectLocator;
import org.jvnet.basicjaxb.locator.ObjectLocator;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.plugin.util.StrategyClassUtils;
import org.jvnet.basicjaxb.util.ClassUtils;
import org.jvnet.basicjaxb.util.FieldAccessorFactory;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.util.PropertyFieldAccessorFactory;
import org.jvnet.basicjaxb.xjc.outline.FieldAccessorEx;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class ToStringPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XtoString";
    private static final String OPTION_DESC = "generate reflection-free 'toString' methods";
    private FieldAccessorFactory fieldAccessorFactory = PropertyFieldAccessorFactory.INSTANCE;
    private String toStringStrategyClass = JAXBToStringStrategy.class.getName();
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.tostring.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public FieldAccessorFactory getFieldAccessorFactory() {
        return this.fieldAccessorFactory;
    }

    public void setFieldAccessorFactory(FieldAccessorFactory fieldAccessorFactory) {
        this.fieldAccessorFactory = fieldAccessorFactory;
    }

    public String getToStringStrategyClass() {
        return this.toStringStrategyClass;
    }

    public void setToStringStrategyClass(String toStringStrategy) {
        this.toStringStrategyClass = toStringStrategy;
    }

    public JExpression createToStringStrategy(JCodeModel codeModel) {
        return StrategyClassUtils.createStrategyInstanceExpression(codeModel, ToStringStrategy.class, this.getToStringStrategyClass());
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.tostring.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  ToStringStrategyClass.: " + this.getToStringStrategyClass());
            sb.append("\n  Verbose...............: " + this.isVerbose());
            sb.append("\n  Debug.................: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(ClassOutline classOutline) {
        JDefinedClass theClass = classOutline.implClass;
        if (!StrategyClassUtils.superClassImplements(classOutline, this.getIgnoring(), ToString.class, false).booleanValue()) {
            ClassUtils._implements((JDefinedClass)theClass, (JClass)theClass.owner().ref(ToString.class));
            this.generateObject$toString(classOutline, theClass);
            this.generateToString$append(classOutline, theClass);
        }
        this.generateToString$appendFields(classOutline, theClass);
    }

    protected JMethod generateObject$toString(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod object$toString = theClass.method(1, (JType)codeModel.ref(String.class), "toString");
        object$toString.annotate(Override.class);
        JBlock body = object$toString.body();
        JVar theLocator = body.decl(0, (JType)codeModel.ref(ObjectLocator.class), "theLocator", JExpr._null());
        JVar toStringStrategy = body.decl(8, (JType)codeModel.ref(ToStringStrategy.class), "strategy", this.createToStringStrategy(codeModel));
        JInvocation theRootLocator = JExpr._new((JClass)codeModel.ref(DefaultRootObjectLocator.class)).arg(JExpr._this());
        JConditional ifTraceEnabled = body._if((JExpression)toStringStrategy.invoke("isTraceEnabled"));
        ifTraceEnabled._then().assign((JAssignmentTarget)theLocator, (JExpression)theRootLocator);
        JVar buffer = body.decl(8, (JType)codeModel.ref(StringBuilder.class), "buffer", (JExpression)JExpr._new((JClass)codeModel.ref(StringBuilder.class)));
        body.invoke("append").arg((JExpression)theLocator).arg((JExpression)buffer).arg((JExpression)toStringStrategy);
        body._return((JExpression)buffer.invoke("toString"));
        this.debug("{}, generateObject$toString; Class={}", new Object[]{LocatorUtils.toLocation((Object)theClass.metadata), theClass.name()});
        return object$toString;
    }

    protected JMethod generateToString$append(ClassOutline classOutline, JDefinedClass theClass) {
        JCodeModel codeModel = theClass.owner();
        JMethod toString$append = theClass.method(1, (JType)codeModel.ref(StringBuilder.class), "append");
        toString$append.annotate(Override.class);
        JVar locator = toString$append.param(ObjectLocator.class, "locator");
        JVar buffer = toString$append.param(StringBuilder.class, "buffer");
        JVar toStringStrategy = toString$append.param(ToStringStrategy.class, "strategy");
        JBlock body = toString$append.body();
        body.invoke((JExpression)toStringStrategy, "appendStart").arg((JExpression)locator).arg(JExpr._this()).arg((JExpression)buffer);
        body.invoke("appendFields").arg((JExpression)locator).arg((JExpression)buffer).arg((JExpression)toStringStrategy);
        body.invoke((JExpression)toStringStrategy, "appendEnd").arg((JExpression)locator).arg(JExpr._this()).arg((JExpression)buffer);
        body._return((JExpression)buffer);
        return toString$append;
    }

    protected JMethod generateToString$appendFields(ClassOutline classOutline, JDefinedClass theClass) {
        FieldOutline[] declaredFields;
        JCodeModel codeModel = theClass.owner();
        JMethod toString$appendFields = theClass.method(1, (JType)codeModel.ref(StringBuilder.class), "appendFields");
        toString$appendFields.annotate(Override.class);
        JVar locator = toString$appendFields.param(ObjectLocator.class, "locator");
        JVar buffer = toString$appendFields.param(StringBuilder.class, "buffer");
        JVar toStringStrategy = toString$appendFields.param(ToStringStrategy.class, "strategy");
        JBlock body = toString$appendFields.body();
        Boolean superClassImplementsToString = StrategyClassUtils.superClassImplements(classOutline, this.ignoring, ToString.class);
        if (superClassImplementsToString != null && superClassImplementsToString.booleanValue()) {
            body.invoke(JExpr._super(), "appendFields").arg((JExpression)locator).arg((JExpression)buffer).arg((JExpression)toStringStrategy);
        }
        if ((declaredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())).length > 0) {
            for (FieldOutline fieldOutline : declaredFields) {
                JBlock block = body.block();
                FieldAccessorEx fieldAccessor = this.getFieldAccessorFactory().createFieldAccessor(fieldOutline, JExpr._this());
                JExpression theFieldIsSetEx = fieldAccessor.isAlwaysSet() || fieldAccessor.hasSetValue() == null ? JExpr.TRUE : fieldAccessor.hasSetValue();
                JVar theFieldIsSet = block.decl(codeModel.ref(Boolean.class).unboxify(), "theFieldIsSet", theFieldIsSetEx);
                JVar theField = block.decl(fieldAccessor.getType(), this.fieldName("the"));
                fieldAccessor.toRawValue(block, theField);
                String fieldName = this.fieldName(fieldOutline);
                block.invoke((JExpression)toStringStrategy, "appendField").arg((JExpression)locator).arg(JExpr._this()).arg(JExpr.lit((String)fieldName)).arg((JExpression)buffer).arg((JExpression)theField).arg((JExpression)theFieldIsSet);
                this.trace("{}, generateHashCode$hashCode; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldOutline.getPropertyInfo().getLocator()), theClass.name(), fieldName});
            }
        }
        body._return((JExpression)buffer);
        return toString$appendFields;
    }

    private String fieldName(FieldOutline fieldOutline) {
        return fieldOutline.getPropertyInfo().getName(false);
    }

    private String fieldName(String prefix) {
        return prefix + "Field";
    }

    private String fieldName(String prefix, FieldOutline fieldOutline) {
        return this.fieldName(prefix) + fieldOutline.getPropertyInfo().getName(true);
    }
}

