/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.fluentapi;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPrimitiveType;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.model.CClassInfo;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.fluentapi.FluentMethodInfo;
import org.jvnet.basicjaxb.plugin.fluentapi.FluentMethodType;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class FluentApiPlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XfluentAPI";
    private static final String OPTION_DESC = "enable Fluent API, method chaining, for generated code";
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.fluentapi.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    public static final String GETTER_METHOD_PREFIX = "get";
    public static final String SETTER_METHOD_PREFIX = "set";
    public static final String FLUENT_METHOD_PREFIX = "use";
    public static final int SETTER_METHOD_PREFIX_LEN = "set".length();
    public static final int GETTER_METHOD_PREFIX_LEN = "get".length();
    public static final String PARAMETERIZED_LIST_PREFIX = List.class.getName() + "<";
    private String fluentMethodPrefix = "use";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.fluentapi.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    public String getFluentMethodPrefix() {
        return this.fluentMethodPrefix;
    }

    public void setFluentMethodPrefix(String fluentMethodPrefix) {
        this.fluentMethodPrefix = fluentMethodPrefix;
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  FluentMethodPrefix.: " + this.getFluentMethodPrefix());
            sb.append("\n  Verbose............: " + this.isVerbose());
            sb.append("\n  Debug..............: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        JPrimitiveType voidType = outline.getCodeModel().VOID;
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(classOutline, (JType)voidType);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    private void processClassOutline(ClassOutline classOutline, JType voidType) {
        JDefinedClass targetClass = classOutline.implClass;
        HashMap<String, FieldOutline> filteredFieldMap = new HashMap<String, FieldOutline>();
        this.putFieldOutlines(filteredFieldMap, this.getSuperClassFilteredFields(classOutline));
        this.putFieldOutlines(filteredFieldMap, OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring()));
        ArrayList<FluentMethodInfo> fluentMethodInfoList = new ArrayList<FluentMethodInfo>();
        HashSet<String> originalMethodNames = new HashSet<String>();
        boolean isOverride = false;
        while (classOutline != null) {
            JDefinedClass implClass = classOutline.implClass;
            String implFullClassName = this.fullClassName(implClass);
            for (JMethod originalMethod : implClass.methods()) {
                String originalMethodName = originalMethod.name();
                if (originalMethodNames.contains(originalMethodName)) continue;
                FieldOutline fieldOutline = (FieldOutline)filteredFieldMap.get(implFullClassName + "." + originalMethodName);
                if (fieldOutline != null) {
                    if (this.isSetterMethod(originalMethod, voidType)) {
                        fluentMethodInfoList.add(new FluentMethodInfo(originalMethod, FluentMethodType.FLUENT_SETTER, isOverride, this));
                    } else if (this.isListGetterMethod(originalMethod)) {
                        fluentMethodInfoList.add(new FluentMethodInfo(originalMethod, FluentMethodType.FLUENT_LIST_SETTER, isOverride, this));
                        fluentMethodInfoList.add(new FluentMethodInfo(originalMethod, FluentMethodType.FLUENT_COLLECTION_SETTER, isOverride, this));
                    }
                    CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
                    this.trace("{}, processClassOutline; Class={}, Field={}", new Object[]{LocatorUtils.toLocation((Locator)fieldInfo.getLocator()), targetClass.name(), fieldInfo.getName(false)});
                }
                originalMethodNames.add(originalMethodName);
            }
            if ((classOutline = classOutline.getSuperClass()) == null) continue;
            isOverride = true;
        }
        for (FluentMethodInfo fluentMethodInfo : fluentMethodInfoList) {
            fluentMethodInfo.createFluentMethod(targetClass);
        }
        this.debug("{}, processClassOutline; Class={}", new Object[]{LocatorUtils.toLocation((Object)targetClass.metadata), targetClass.name()});
    }

    private String fullClassName(JDefinedClass definedClass) {
        JDefinedClass currentClass = definedClass;
        StringBuilder sb = new StringBuilder(currentClass.name());
        while ((currentClass = currentClass.outer()) != null) {
            sb.insert(0, currentClass.name() + ".");
        }
        if (definedClass.getPackage() != null) {
            sb.insert(0, definedClass.getPackage().name() + ".");
        }
        return sb.toString();
    }

    private void putFieldOutlines(Map<String, FieldOutline> fieldMethodMap, FieldOutline[] classFields) {
        for (FieldOutline fieldOutline : classFields) {
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            CClassInfo fieldParent = (CClassInfo)fieldInfo.parent();
            String fullClassName = fieldParent.getName();
            String fieldPublicName = fieldInfo.getName(true);
            String fieldMethodName = null;
            fieldMethodName = fieldInfo.isCollection() ? GETTER_METHOD_PREFIX + fieldPublicName : SETTER_METHOD_PREFIX + fieldPublicName;
            fieldMethodMap.put(fullClassName + "." + fieldMethodName, fieldOutline);
        }
    }

    private boolean isSetterMethod(JMethod method, JType setterType) {
        if (method.type() == setterType) {
            JVar[] jvars = method.listParams();
            switch (jvars.length) {
                case 2: {
                    if (!this.isInt(jvars[0].type())) {
                        return false;
                    }
                }
                case 1: {
                    int mods = method.mods().getValue();
                    if ((mods & 0x10) != 0 || (mods & 1) != 1) break;
                    String methodName = method.name();
                    return methodName.length() > SETTER_METHOD_PREFIX_LEN && methodName.startsWith(SETTER_METHOD_PREFIX);
                }
            }
        }
        return false;
    }

    private boolean isListGetterMethod(JMethod method) {
        int mods = method.mods().getValue();
        if ((mods & 0x10) == 1 || (mods & 1) == 0) {
            return false;
        }
        String methodName = method.name();
        if (methodName.length() <= GETTER_METHOD_PREFIX_LEN || !methodName.startsWith(GETTER_METHOD_PREFIX)) {
            return false;
        }
        if (method.listParams().length > 0) {
            return false;
        }
        JType jtype = method.type();
        if (jtype instanceof JClass) {
            JClass jclass = (JClass)JClass.class.cast(jtype);
            List typeParams = jclass.getTypeParameters();
            if (typeParams.size() != 1) {
                return false;
            }
            return jclass.fullName().startsWith(PARAMETERIZED_LIST_PREFIX);
        }
        return false;
    }

    private boolean isInt(JType type) {
        JCodeModel codeModel = type.owner();
        return type.isPrimitive() && codeModel.INT.equals(JType.parse((JCodeModel)codeModel, (String)type.name()));
    }

    protected FieldOutline[] getSuperClassFilteredFields(ClassOutline classOutline) {
        LinkedList fieldOutlineList = new LinkedList();
        for (ClassOutline sco = classOutline.getSuperClass(); sco != null; sco = sco.getSuperClass()) {
            FieldOutline[] superFieldOutlines = OutlineUtils.filter(sco.getDeclaredFields(), this.getIgnoring());
            ArrayList<FieldOutline> superFieldOutlineList = new ArrayList<FieldOutline>();
            for (FieldOutline superFieldOutline : superFieldOutlines) {
                superFieldOutlineList.add(superFieldOutline);
            }
            fieldOutlineList.addAll(0, superFieldOutlineList);
        }
        return fieldOutlineList.toArray(new FieldOutline[fieldOutlineList.size()]);
    }
}

