/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.basicjaxb.plugin.defaultvalue;

import com.sun.codemodel.ClassType;
import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JConditional;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import com.sun.tools.xjc.model.CPropertyInfo;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumConstantOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.jvnet.basicjaxb.dom.DOMUtils;
import org.jvnet.basicjaxb.lang.ValueUtils;
import org.jvnet.basicjaxb.plugin.AbstractParameterizablePlugin;
import org.jvnet.basicjaxb.plugin.Customizations;
import org.jvnet.basicjaxb.plugin.CustomizedIgnoring;
import org.jvnet.basicjaxb.plugin.Ignoring;
import org.jvnet.basicjaxb.plugin.util.OutlineUtils;
import org.jvnet.basicjaxb.util.LocatorUtils;
import org.jvnet.basicjaxb.xml.namespace.util.QNameUtils;
import org.jvnet.basicjaxb.xmlschema.XmlSchemaConstants;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;

public class DefaultValuePlugin
extends AbstractParameterizablePlugin {
    private static final String OPTION_NAME = "XdefaultValue";
    private static final String OPTION_DESC = "enable rewriting of classes to set default values as specified in XML schema";
    private static final JType[] NO_ARGS = new JType[0];
    private Ignoring ignoring = new CustomizedIgnoring(org.jvnet.basicjaxb.plugin.defaultvalue.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return String.format("  -%-20s : %s", OPTION_NAME, OPTION_DESC);
    }

    public Ignoring getIgnoring() {
        return this.ignoring;
    }

    public void setIgnoring(Ignoring ignoring) {
        this.ignoring = ignoring;
    }

    public Collection<QName> getCustomizationElementNames() {
        return Arrays.asList(org.jvnet.basicjaxb.plugin.defaultvalue.Customizations.IGNORED_ELEMENT_NAME, Customizations.IGNORED_ELEMENT_NAME, Customizations.GENERATED_ELEMENT_NAME);
    }

    protected void beforeRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Start");
            sb.append("\nParameters");
            sb.append("\n  Verbose.: " + this.isVerbose());
            sb.append("\n  Debug...: " + this.isDebug());
            this.info(sb.toString(), new Object[0]);
        }
    }

    protected void afterRun(Outline outline) throws Exception {
        if (this.isInfoEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(": Finish");
            sb.append("\nResults");
            sb.append("\n  HadError.: " + this.hadError((ErrorHandler)outline.getErrorReceiver()));
            this.info(sb.toString(), new Object[0]);
        }
    }

    public boolean run(Outline outline) throws Exception {
        for (ClassOutline classOutline : OutlineUtils.filter(outline, this.getIgnoring())) {
            this.processClassOutline(outline, classOutline);
        }
        return !this.hadError((ErrorHandler)outline.getErrorReceiver());
    }

    protected void processClassOutline(Outline outline, ClassOutline classOutline) {
        FieldOutline[] declaredFilteredFields;
        for (FieldOutline fieldOutline : declaredFilteredFields = OutlineUtils.filter(classOutline.getDeclaredFields(), this.getIgnoring())) {
            XSElementDecl element;
            XSParticle particle;
            XSTerm term;
            JType fieldRawType = fieldOutline.getRawType();
            boolean fieldIsPrimitive = fieldRawType.isPrimitive();
            JType fieldType = fieldIsPrimitive ? fieldRawType.boxify() : fieldRawType;
            String typeFullName = fieldType.fullName();
            String defaultValue = null;
            CPropertyInfo fieldInfo = fieldOutline.getPropertyInfo();
            QName schemaType = fieldInfo.getSchemaType();
            if (fieldInfo.getSchemaComponent() instanceof XSAttributeUse) {
                XSAttributeUse attribute = (XSAttributeUse)fieldInfo.getSchemaComponent();
                if ((XMLGregorianCalendar.class.getName().equals(typeFullName) || Duration.class.getName().equals(typeFullName) || (List.class.getName() + "<" + BigDecimal.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + BigInteger.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Boolean.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Byte.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Double.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Duration.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Float.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Integer.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Long.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + Short.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + String.class.getName() + ">").equals(typeFullName) || (List.class.getName() + "<" + XMLGregorianCalendar.class.getName() + ">").equals(typeFullName)) && attribute.getDefaultValue() != null) {
                    XSAttributeDecl attrDecl;
                    defaultValue = attribute.getDefaultValue().value;
                    if (schemaType == null && (attrDecl = attribute.getDecl()) != null) {
                        schemaType = new QName(attrDecl.getTargetNamespace(), attrDecl.getName());
                    }
                }
            } else if (fieldInfo.getSchemaComponent() instanceof XSParticle && (term = (particle = (XSParticle)fieldInfo.getSchemaComponent()).getTerm()).isElementDecl() && (element = term.asElementDecl()).getDefaultValue() != null) {
                XSType elementType;
                defaultValue = element.getDefaultValue().value;
                if (schemaType == null && (elementType = element.getType()) != null) {
                    schemaType = new QName(elementType.getTargetNamespace(), elementType.getName());
                }
            }
            if (defaultValue == null) continue;
            this.processDefaultValue(outline, classOutline, fieldInfo, fieldType, fieldIsPrimitive, typeFullName, defaultValue, schemaType);
        }
    }

    private void processDefaultValue(Outline outline, ClassOutline classOutline, CPropertyInfo fieldInfo, JType fieldType, boolean fieldIsPrimitive, String typeFullName, String defaultValue, QName schemaType) {
        JDefinedClass theClass = classOutline.implClass;
        Map fields = theClass.fields();
        JFieldVar var = (JFieldVar)fields.get(fieldInfo.getName(false));
        String publicName = fieldInfo.getName(true);
        String accessorName = "get" + publicName;
        JMethod accessor = theClass.getMethod(accessorName, NO_ARGS);
        if (accessor == null) {
            accessorName = "is" + publicName;
            accessor = theClass.getMethod(accessorName, NO_ARGS);
        }
        JCodeModel theCodeModel = theClass.owner();
        JClass refValueUtils = theCodeModel.ref(ValueUtils.class);
        String fieldLoc = LocatorUtils.toLocation((Locator)fieldInfo.getLocator());
        String fieldName = fieldInfo.displayName();
        if (fieldType instanceof JDefinedClass && ((JDefinedClass)fieldType).getClassType() == ClassType.ENUM) {
            JEnumConstant literalValue = this.findEnumConstant(fieldType, defaultValue, outline);
            if (literalValue != null) {
                this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
                this.debug("{}, processDefaultValue; {} = {} (Enum)", new Object[]{fieldLoc, fieldName, literalValue.getName()});
            }
        } else if (String.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toString").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = \"{}\" (String)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Boolean.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBoolean").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Boolean)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Byte.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toByte").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Byte)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Short.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toShort").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Short)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Integer.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toInteger").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Integer)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Long.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toLong").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Long)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Float.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toFloat").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Float)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Double.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDouble").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Double)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (BigDecimal.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBigDecimal").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (BigDecimal)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (BigInteger.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBigInteger").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (BigInteger)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (byte[].class.getCanonicalName().equals(typeFullName) && schemaType == null || byte[].class.getCanonicalName().equals(typeFullName) && XmlSchemaConstants.BASE64BINARY.equals(schemaType)) {
            JInvocation literalValue = refValueUtils.staticInvoke("parseBase64Binary").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Base64Binary)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (byte[].class.getCanonicalName().equals(typeFullName) && XmlSchemaConstants.HEXBINARY.equals(schemaType)) {
            JInvocation literalValue = refValueUtils.staticInvoke("parseHexBinary").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (HexBinary)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (XMLGregorianCalendar.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toXMLGregorianCalendar").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (XMLGregorianCalendar)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Duration.class.getName().equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDuration").arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (Duration)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (QName.class.getName().equals(typeFullName)) {
            JFieldVar ofField = (JFieldVar)theClass.fields().get("OBJECT_FACTORY");
            if (ofField == null) {
                ofField = this.installObjectFactory(theClass);
            }
            JClass refQNameUtils = theCodeModel.ref(QNameUtils.class);
            JInvocation jaxbElement = JExpr.invoke((JExpression)ofField, (String)("create" + publicName)).arg(JExpr._null());
            JInvocation literalValue = refQNameUtils.staticInvoke("toName").arg((JExpression)jaxbElement).arg(defaultValue);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {} (QName)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if (Object.class.getName().equals(typeFullName) && XmlSchemaConstants.ANYSIMPLETYPE.equals(schemaType)) {
            JFieldVar ofField = (JFieldVar)theClass.fields().get("OBJECT_FACTORY");
            if (ofField == null) {
                ofField = this.installObjectFactory(theClass);
            }
            JClass refDOMUtils = theCodeModel.ref(DOMUtils.class);
            JInvocation jaxbElement = JExpr.invoke((JExpression)ofField, (String)("create" + publicName)).arg(defaultValue);
            JInvocation literalValue = refDOMUtils.staticInvoke("toNode").arg((JExpression)jaxbElement);
            this.initializer(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = \"{}\" (Object)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + BigDecimal.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBigDecimalList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<BigDecimal>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + BigInteger.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBigIntegerList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<BigInteger>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Boolean.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toBooleanList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Boolean>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Byte.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toByteList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Byte>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Double.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDoubleList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Double>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Duration.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toDurationList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Duration>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Float.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toFloatList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Float>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Integer.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toIntegerList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Integer>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Long.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toLongList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Long>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + Short.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toShortList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<Short>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + String.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toStringList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<String>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else if ((List.class.getName() + "<" + XMLGregorianCalendar.class.getName() + ">").equals(typeFullName)) {
            JInvocation literalValue = refValueUtils.staticInvoke("toXMLGregorianCalendarList").arg(defaultValue);
            this.initializerList(var, accessor, fieldIsPrimitive, (JExpression)literalValue);
            this.debug("{}, processDefaultValue; {} = {{}} (List<XMLGregorianCalendar>)", new Object[]{fieldLoc, fieldName, defaultValue});
        } else {
            this.warn("{}, processDefaultValue; Did not create default value for field {}. Don't know how to create default value expression for fields of type {} with schema type {}. Default value of \"{}\" specified in schema.", new Object[]{fieldLoc, fieldName, typeFullName, schemaType, defaultValue});
        }
    }

    private void initializerList(JFieldVar var, JMethod accessor, boolean fieldIsPrimitive, JExpression literalValue) {
        if (accessor != null && !fieldIsPrimitive) {
            accessor.body().pos(1);
            JConditional ifVarIsEmpty = accessor.body()._if((JExpression)JExpr.invoke((JExpression)var, (String)"isEmpty"));
            ifVarIsEmpty._then().assign((JAssignmentTarget)var, literalValue);
        } else {
            var.init(literalValue);
        }
    }

    private void initializer(JFieldVar var, JMethod accessor, boolean fieldIsPrimitive, JExpression literalValue) {
        if (accessor != null && !fieldIsPrimitive) {
            accessor.body().pos(0);
            JConditional ifVarIsNull = accessor.body()._if(var.eq(JExpr._null()));
            ifVarIsNull._then()._return(literalValue);
        } else {
            var.init(literalValue);
        }
    }

    private JEnumConstant findEnumConstant(JType enumType, String enumStringValue, Outline outline) {
        JEnumConstant ec = null;
        for (EnumOutline eo : outline.getEnums()) {
            if (eo.getImplClass() != enumType) continue;
            for (EnumConstantOutline eco : eo.constants) {
                if (!eco.target.getLexicalValue().equals(enumStringValue)) continue;
                ec = eco.constRef;
                break;
            }
            if (ec != null) continue;
            this.warn("{}, findEnumConstant; Could not find EnumConstant for value: \"{}\"", new Object[]{LocatorUtils.toLocation((Object)eo.getImplClass().metadata), enumStringValue});
            break;
        }
        if (ec == null) {
            this.warn("findEnumConstant; Could not find Enum class for type: " + enumType.fullName(), new Object[0]);
        }
        return ec;
    }

    private JFieldVar installObjectFactory(JDefinedClass theClass) {
        JClass ofClass = theClass.owner().ref(theClass.getPackage().name() + ".ObjectFactory");
        return theClass.field(28, (JType)ofClass, "OBJECT_FACTORY", JExpr.direct((String)"new ObjectFactory()"));
    }
}

