/*
 * Decompiled with CFR 0.152.
 */
package org.parceler.converter;

import android.os.Parcel;
import java.util.Collection;
import org.parceler.ParcelConverter;

public abstract class CollectionParcelConverter<T>
implements ParcelConverter<Collection<T>> {
    private static final int NULL = -1;

    @Override
    public void toParcel(Collection<T> input, Parcel parcel) {
        if (input == null) {
            parcel.writeInt(-1);
        } else {
            parcel.writeInt(input.size());
            for (T item : input) {
                this.itemToParcel(item, parcel);
            }
        }
    }

    @Override
    public Collection<T> fromParcel(Parcel parcel) {
        Collection<T> list;
        int size = parcel.readInt();
        if (size == -1) {
            list = null;
        } else {
            list = this.createCollection();
            for (int i = 0; i < size; ++i) {
                list.add(this.itemFromParcel(parcel));
            }
        }
        return list;
    }

    public abstract void itemToParcel(T var1, Parcel var2);

    public abstract T itemFromParcel(Parcel var1);

    public abstract Collection<T> createCollection();
}

