/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;
import org.parboiled.transform.Types;

class LabellingGenerator
implements RuleMethodProcessor {
    LabellingGenerator() {
    }

    @Override
    public boolean appliesTo(ParserClassNode parserClassNode, RuleMethod ruleMethod) {
        Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method");
        return !ruleMethod.hasDontLabelAnnotation();
    }

    @Override
    public void process(ParserClassNode parserClassNode, RuleMethod ruleMethod) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)parserClassNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)ruleMethod), (String)"method");
        Preconditions.checkState((!ruleMethod.isSuperMethod() ? 1 : 0) != 0);
        InsnList insnList = ruleMethod.instructions;
        AbstractInsnNode abstractInsnNode = insnList.getLast();
        while (abstractInsnNode.getOpcode() != 176) {
            abstractInsnNode = abstractInsnNode.getPrevious();
        }
        LabelNode labelNode = new LabelNode();
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(89));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new JumpInsnNode(198, labelNode));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new LdcInsnNode((Object)this.getLabelText(ruleMethod)));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)new MethodInsnNode(185, Types.RULE.getInternalName(), "label", "(Ljava/lang/String;)" + Types.RULE_DESC, true));
        insnList.insertBefore(abstractInsnNode, (AbstractInsnNode)labelNode);
    }

    public String getLabelText(RuleMethod ruleMethod) {
        if (ruleMethod.visibleAnnotations != null) {
            for (Object e : ruleMethod.visibleAnnotations) {
                AnnotationNode annotationNode = (AnnotationNode)e;
                if (!annotationNode.desc.equals(Types.LABEL_DESC) || annotationNode.values == null) continue;
                Preconditions.checkState((boolean)"value".equals(annotationNode.values.get(0)));
                String string = (String)annotationNode.values.get(1);
                return StringUtils.isEmpty((String)string) ? ruleMethod.name : string;
            }
        }
        return ruleMethod.name;
    }
}

