/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.parboiled.BaseParser;
import org.parboiled.ContextAware;
import org.parboiled.common.Preconditions;
import org.parboiled.support.Var;

class AsmUtils {
    private static final Map<String, Class<?>> classForDesc = new HashMap();

    AsmUtils() {
    }

    public static ClassReader createClassReader(Class<?> clazz) throws IOException {
        Preconditions.checkArgNotNull(clazz, (String)"clazz");
        String string = clazz.getName().replace('.', '/') + ".class";
        InputStream inputStream = clazz.getClassLoader().getResourceAsStream(string);
        if (inputStream == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(string);
        }
        return new ClassReader(inputStream);
    }

    public static String getExtendedParserClassName(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"parserClassName");
        return string + "$$parboiled";
    }

    public static synchronized Class<?> getClassForInternalName(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"classDesc");
        Class<?> clazz = classForDesc.get(string);
        if (clazz == null) {
            if (string.charAt(0) == '[') {
                Class<?> clazz2 = AsmUtils.getClassForType(Type.getType((String)string.substring(1)));
                clazz = Array.newInstance(clazz2, 0).getClass();
            } else {
                String string2 = string.replace('/', '.');
                try {
                    clazz = AsmUtils.class.getClassLoader().loadClass(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    try {
                        clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
                    }
                    catch (ClassNotFoundException classNotFoundException2) {
                        throw new RuntimeException("Error loading class '" + string2 + "' for rule method analysis", classNotFoundException2);
                    }
                }
            }
            classForDesc.put(string, clazz);
        }
        return clazz;
    }

    public static synchronized void clearClassCache() {
        classForDesc.clear();
    }

    public static Class<?> getClassForType(Type type) {
        Preconditions.checkArgNotNull((Object)type, (String)"type");
        switch (type.getSort()) {
            case 1: {
                return Boolean.TYPE;
            }
            case 3: {
                return Byte.TYPE;
            }
            case 2: {
                return Character.TYPE;
            }
            case 8: {
                return Double.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 5: {
                return Integer.TYPE;
            }
            case 7: {
                return Long.TYPE;
            }
            case 4: {
                return Short.TYPE;
            }
            case 0: {
                return Void.TYPE;
            }
            case 9: 
            case 10: {
                return AsmUtils.getClassForInternalName(type.getInternalName());
            }
        }
        throw new IllegalStateException();
    }

    public static Field getClassField(String string, String string2) {
        Class<?> clazz;
        Preconditions.checkArgNotNull((Object)string, (String)"classInternalName");
        Preconditions.checkArgNotNull((Object)string2, (String)"fieldName");
        Class<?> clazz2 = clazz = AsmUtils.getClassForInternalName(string);
        while (true) {
            try {
                return clazz2.getDeclaredField(string2);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                if (!Object.class.equals(clazz2 = clazz2.getSuperclass())) continue;
                throw new RuntimeException("Field '" + string2 + "' not found in '" + clazz + "' or any superclass", noSuchFieldException);
            }
            break;
        }
    }

    public static Method getClassMethod(String string, String string2, String string3) {
        Preconditions.checkArgNotNull((Object)string, (String)"classInternalName");
        Preconditions.checkArgNotNull((Object)string2, (String)"methodName");
        Preconditions.checkArgNotNull((Object)string3, (String)"methodDesc");
        Class<?> clazz = AsmUtils.getClassForInternalName(string);
        Type[] typeArray = Type.getArgumentTypes((String)string3);
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            classArray[i] = AsmUtils.getClassForType(typeArray[i]);
        }
        Method method = AsmUtils.findMethod(clazz, string2, classArray);
        if (method == null) {
            throw new RuntimeException("Method '" + string2 + "' with descriptor '" + string3 + "' not found in '" + clazz + "' or any supertype");
        }
        return method;
    }

    private static Method findMethod(Class<?> clazz, String string, Class<?>[] classArray) {
        Method method;
        block4: {
            method = null;
            if (clazz != null) {
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Class<?> clazz2;
                    method = AsmUtils.findMethod(clazz.getSuperclass(), string, classArray);
                    if (method != null) break block4;
                    Class<?>[] classArray2 = clazz.getInterfaces();
                    int n = classArray2.length;
                    for (int i = 0; i < n && (method = AsmUtils.findMethod(clazz2 = classArray2[i], string, classArray)) == null; ++i) {
                    }
                }
            }
        }
        return method;
    }

    public static Constructor getClassConstructor(String string, String string2) {
        Preconditions.checkArgNotNull((Object)string, (String)"classInternalName");
        Preconditions.checkArgNotNull((Object)string2, (String)"constructorDesc");
        Class<?> clazz = AsmUtils.getClassForInternalName(string);
        Type[] typeArray = Type.getArgumentTypes((String)string2);
        Class[] classArray = new Class[typeArray.length];
        for (int i = 0; i < typeArray.length; ++i) {
            classArray[i] = AsmUtils.getClassForType(typeArray[i]);
        }
        try {
            return clazz.getDeclaredConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Constructor with descriptor '" + string2 + "' not found in '" + clazz, noSuchMethodException);
        }
    }

    public static Class<?> findLoadedClass(String string, ClassLoader classLoader, Class<?> clazz) {
        Preconditions.checkArgNotNull((Object)string, (String)"className");
        Preconditions.checkArgNotNull(clazz, (String)"origClass");
        try {
            return (Class)clazz.getMethod("findLoadedClass", String.class).invoke(null, string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not determine whether class '" + string + "' has already been loaded", exception);
        }
    }

    public static Class<?> loadClass(String string, byte[] byArray, ClassLoader classLoader, Class<?> clazz) {
        Preconditions.checkArgNotNull((Object)byArray, (String)"code");
        Preconditions.checkArgNotNull(clazz, (String)"origClass");
        try {
            return (Class)clazz.getMethod("loadClass", byte[].class).invoke(null, new Object[]{byArray});
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not load class '" + string + "'", exception);
        }
    }

    public static InsnList createArgumentLoaders(String string) {
        Preconditions.checkArgNotNull((Object)string, (String)"methodDescriptor");
        InsnList insnList = new InsnList();
        Type[] typeArray = Type.getArgumentTypes((String)string);
        for (int i = 0; i < typeArray.length; ++i) {
            insnList.add((AbstractInsnNode)new VarInsnNode(AsmUtils.getLoadingOpcode(typeArray[i]), i + 1));
        }
        return insnList;
    }

    public static int getLoadingOpcode(Type type) {
        Preconditions.checkArgNotNull((Object)type, (String)"argType");
        switch (type.getSort()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 21;
            }
            case 8: {
                return 24;
            }
            case 6: {
                return 23;
            }
            case 7: {
                return 22;
            }
            case 9: 
            case 10: {
                return 25;
            }
        }
        throw new IllegalStateException();
    }

    public static boolean isAssignableTo(String string, Class<?> clazz) {
        Preconditions.checkArgNotNull((Object)string, (String)"classInternalName");
        Preconditions.checkArgNotNull(clazz, (String)"type");
        return clazz.isAssignableFrom(AsmUtils.getClassForInternalName(string));
    }

    public static boolean isBooleanValueOfZ(AbstractInsnNode abstractInsnNode) {
        Preconditions.checkArgNotNull((Object)abstractInsnNode, (String)"insn");
        if (abstractInsnNode.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isBooleanValueOfZ(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
    }

    public static boolean isBooleanValueOfZ(String string, String string2, String string3) {
        Preconditions.checkArgNotNull((Object)string, (String)"methodOwner");
        Preconditions.checkArgNotNull((Object)string2, (String)"methodName");
        Preconditions.checkArgNotNull((Object)string3, (String)"methodDesc");
        return "java/lang/Boolean".equals(string) && "valueOf".equals(string2) && "(Z)Ljava/lang/Boolean;".equals(string3);
    }

    public static boolean isActionRoot(AbstractInsnNode abstractInsnNode) {
        Preconditions.checkArgNotNull((Object)abstractInsnNode, (String)"insn");
        if (abstractInsnNode.getOpcode() != 184) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isActionRoot(methodInsnNode.owner, methodInsnNode.name);
    }

    public static boolean isActionRoot(String string, String string2) {
        Preconditions.checkArgNotNull((Object)string, (String)"methodOwner");
        Preconditions.checkArgNotNull((Object)string2, (String)"methodName");
        return "ACTION".equals(string2) && AsmUtils.isAssignableTo(string, BaseParser.class);
    }

    public static boolean isVarRoot(AbstractInsnNode abstractInsnNode) {
        Preconditions.checkArgNotNull((Object)abstractInsnNode, (String)"insn");
        if (abstractInsnNode.getOpcode() != 183) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isVarRoot(methodInsnNode.owner, methodInsnNode.name, methodInsnNode.desc);
    }

    public static boolean isVarRoot(String string, String string2, String string3) {
        Preconditions.checkArgNotNull((Object)string, (String)"methodOwner");
        Preconditions.checkArgNotNull((Object)string2, (String)"methodName");
        Preconditions.checkArgNotNull((Object)string3, (String)"methodDesc");
        return "<init>".equals(string2) && "(Ljava/lang/Object;)V".equals(string3) && AsmUtils.isAssignableTo(string, Var.class);
    }

    public static boolean isCallOnContextAware(AbstractInsnNode abstractInsnNode) {
        Preconditions.checkArgNotNull((Object)abstractInsnNode, (String)"insn");
        if (abstractInsnNode.getOpcode() != 182 && abstractInsnNode.getOpcode() != 185) {
            return false;
        }
        MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
        return AsmUtils.isAssignableTo(methodInsnNode.owner, ContextAware.class);
    }
}

