/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.parboiled.common.Preconditions;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.RuleMethodProcessor;

class ReturnInstructionUnifier
implements RuleMethodProcessor {
    ReturnInstructionUnifier() {
    }

    public boolean appliesTo(ParserClassNode classNode, RuleMethod method) {
        return true;
    }

    public void process(ParserClassNode classNode, RuleMethod method) throws Exception {
        Preconditions.checkArgNotNull((Object)((Object)classNode), (String)"classNode");
        Preconditions.checkArgNotNull((Object)((Object)method), (String)"method");
        if (method.getNumberOfReturns() == 1) {
            return;
        }
        Preconditions.checkState((method.getNumberOfReturns() > 1 ? 1 : 0) != 0);
        AbstractInsnNode current = method.instructions.getLast();
        while (current.getOpcode() != 176) {
            current = current.getPrevious();
        }
        LabelNode lastReturnLabel = new LabelNode();
        method.instructions.insertBefore(current, (AbstractInsnNode)lastReturnLabel);
        while ((current = current.getPrevious()) != null) {
            if (current.getOpcode() != 176) continue;
            JumpInsnNode gotoInstruction = new JumpInsnNode(167, lastReturnLabel);
            method.instructions.set(current, (AbstractInsnNode)gotoInstruction);
            current = gotoInstruction;
        }
    }
}

