/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.Preconditions;
import org.parboiled.errors.GrammarException;

public final class Utils {
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];

    private Utils() {
    }

    public static Character[] toObjectArray(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        if (cArray.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] characterArray = new Character[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            characterArray[i] = Character.valueOf(cArray[i]);
        }
        return characterArray;
    }

    public static Integer[] toObjectArray(int[] nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] integerArray = new Integer[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            integerArray[i] = nArray[i];
        }
        return integerArray;
    }

    public static Long[] toObjectArray(long[] lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] longArray = new Long[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            longArray[i] = lArray[i];
        }
        return longArray;
    }

    public static Short[] toObjectArray(short[] sArray) {
        if (sArray == null) {
            return null;
        }
        if (sArray.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] shortArray = new Short[sArray.length];
        for (int i = 0; i < sArray.length; ++i) {
            shortArray[i] = sArray[i];
        }
        return shortArray;
    }

    public static Byte[] toObjectArray(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] byteArray = new Byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byteArray[i] = byArray[i];
        }
        return byteArray;
    }

    public static Float[] toObjectArray(float[] fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] floatArray = new Float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            floatArray[i] = Float.valueOf(fArray[i]);
        }
        return floatArray;
    }

    public static Double[] toObjectArray(double[] dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] doubleArray = new Double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            doubleArray[i] = dArray[i];
        }
        return doubleArray;
    }

    public static Boolean[] toObjectArray(boolean[] blArray) {
        if (blArray == null) {
            return null;
        }
        if (blArray.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] booleanArray = new Boolean[blArray.length];
        for (int i = 0; i < blArray.length; ++i) {
            booleanArray[i] = blArray[i];
        }
        return booleanArray;
    }

    public static <T> T[] arrayOf(T t, T ... TArray) {
        Preconditions.checkArgNotNull(TArray, "moreElements");
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, TArray.length + 1);
        objectArray[0] = t;
        System.arraycopy(TArray, 0, objectArray, 1, TArray.length);
        return objectArray;
    }

    public static <T> T[] arrayOf(T t, T t2, T ... TArray) {
        Preconditions.checkArgNotNull(TArray, "moreElements");
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, TArray.length + 2);
        objectArray[0] = t;
        objectArray[1] = t2;
        System.arraycopy(TArray, 0, objectArray, 2, TArray.length);
        return objectArray;
    }

    public static <T> T[] arrayOf(T[] TArray, T t) {
        Preconditions.checkArgNotNull(TArray, "firstElements");
        Class<?> clazz = TArray.getClass().getComponentType();
        Object[] objectArray = (Object[])Array.newInstance(clazz, TArray.length + 1);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        objectArray[TArray.length] = t;
        return objectArray;
    }

    public static String toString(Object object) {
        return object == null ? "" : object.toString();
    }

    public static <T> boolean equal(T t, T t2) {
        return t != null ? t.equals(t2) : t2 == null;
    }

    public static List<Class<?>> getTypeArguments(Class<?> clazz, Class<?> clazz2) {
        Object object;
        Type[] typeArray;
        Type type;
        Preconditions.checkArgNotNull(clazz, "base");
        Preconditions.checkArgNotNull(clazz2, "implementation");
        HashMap hashMap = new HashMap();
        LinkedList<Type> linkedList = new LinkedList<Type>();
        linkedList.add(clazz2);
        while (true) {
            if (linkedList.isEmpty()) {
                return ImmutableList.of();
            }
            type = (Type)linkedList.remove();
            if (type instanceof Class) {
                typeArray = (TypeVariable<Class<T>>[])type;
                if (clazz.isInterface()) {
                    linkedList.addAll(Arrays.asList(typeArray.getGenericInterfaces()));
                }
            } else if (type instanceof ParameterizedType) {
                object = (ParameterizedType)type;
                typeArray = (Class)object.getRawType();
                Type[] typeArray2 = typeArray.getTypeParameters();
                Type[] typeArray3 = object.getActualTypeArguments();
                for (int i = 0; i < typeArray3.length; ++i) {
                    hashMap.put(typeArray2[i], typeArray3[i]);
                }
            } else {
                return ImmutableList.of();
            }
            if (clazz.equals(Utils.getClass(type))) break;
            linkedList.add(typeArray.getGenericSuperclass());
        }
        typeArray = type instanceof Class ? ((Class)type).getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        object = new ArrayList();
        for (Type type2 : typeArray) {
            while (hashMap.containsKey(type2)) {
                type2 = (Type)hashMap.get(type2);
            }
            object.add(Utils.getClass(type2));
        }
        return object;
    }

    public static Class<?> getClass(Type type) {
        Type type2;
        Class<?> clazz;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Utils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType && (clazz = Utils.getClass(type2 = ((GenericArrayType)type).getGenericComponentType())) != null) {
            return Array.newInstance(clazz, 0).getClass();
        }
        return null;
    }

    public static boolean isBoxedType(Class<?> clazz, Class<?> clazz2) {
        return clazz.equals(Boolean.TYPE) && clazz2.equals(Boolean.class) || clazz.equals(Byte.TYPE) && clazz2.equals(Byte.class) || clazz.equals(Character.TYPE) && clazz2.equals(Character.class) || clazz.equals(Double.TYPE) && clazz2.equals(Double.class) || clazz.equals(Float.TYPE) && clazz2.equals(Float.class) || clazz.equals(Integer.TYPE) && clazz2.equals(Integer.class) || clazz.equals(Long.TYPE) && clazz2.equals(Long.class) || clazz.equals(Short.TYPE) && clazz2.equals(Short.class) || clazz.equals(Void.TYPE) && clazz2.equals(Void.class);
    }

    public static Constructor findConstructor(Class<?> clazz, Object[] objectArray) {
        block0: for (Constructor<?> constructor : clazz.getConstructors()) {
            Class<?>[] classArray = constructor.getParameterTypes();
            if (classArray.length != objectArray.length) continue;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object != null && !classArray[i].isAssignableFrom(object.getClass()) && !Utils.isBoxedType(classArray[i], object.getClass()) || object == null && classArray[i].isPrimitive()) continue block0;
            }
            return constructor;
        }
        throw new GrammarException("No constructor found for %s and the given %s arguments", clazz, objectArray.length);
    }

    public static String humanize(long l) {
        if (l < 0L) {
            return "-" + Utils.humanize(-l);
        }
        if (l > 1000000000000000000L) {
            return Double.toString((double)((l + 500000000000000L) / 1000000000000000L * 1000000000000000L) / 1.0E18) + "E";
        }
        if (l > 100000000000000000L) {
            return Double.toString((double)((l + 50000000000000L) / 100000000000000L * 100000000000000L) / 1.0E15) + "P";
        }
        if (l > 10000000000000000L) {
            return Double.toString((double)((l + 5000000000000L) / 10000000000000L * 10000000000000L) / 1.0E15) + "P";
        }
        if (l > 1000000000000000L) {
            return Double.toString((double)((l + 500000000000L) / 1000000000000L * 1000000000000L) / 1.0E15) + "P";
        }
        if (l > 100000000000000L) {
            return Double.toString((double)((l + 50000000000L) / 100000000000L * 100000000000L) / 1.0E12) + "T";
        }
        if (l > 10000000000000L) {
            return Double.toString((double)((l + 5000000000L) / 10000000000L * 10000000000L) / 1.0E12) + "T";
        }
        if (l > 1000000000000L) {
            return Double.toString((double)((l + 500000000L) / 1000000000L * 1000000000L) / 1.0E12) + "T";
        }
        if (l > 100000000000L) {
            return Double.toString((double)((l + 50000000L) / 100000000L * 100000000L) / 1.0E9) + "G";
        }
        if (l > 10000000000L) {
            return Double.toString((double)((l + 5000000L) / 10000000L * 10000000L) / 1.0E9) + "G";
        }
        if (l > 1000000000L) {
            return Double.toString((double)((l + 500000L) / 1000000L * 1000000L) / 1.0E9) + "G";
        }
        if (l > 100000000L) {
            return Double.toString((double)((l + 50000L) / 100000L * 100000L) / 1000000.0) + "M";
        }
        if (l > 10000000L) {
            return Double.toString((double)((l + 5000L) / 10000L * 10000L) / 1000000.0) + "M";
        }
        if (l > 1000000L) {
            return Double.toString((double)((l + 500L) / 1000L * 1000L) / 1000000.0) + "M";
        }
        if (l > 100000L) {
            return Double.toString((double)((l + 50L) / 100L * 100L) / 1000.0) + "K";
        }
        if (l > 10000L) {
            return Double.toString((double)((l + 5L) / 10L * 10L) / 1000.0) + "K";
        }
        if (l > 1000L) {
            return Double.toString((double)l / 1000.0) + "K";
        }
        return Long.toString(l) + " ";
    }
}

