/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.common;

import java.util.AbstractSequentialList;
import java.util.ListIterator;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Utils;

public class ImmutableLinkedList<T>
extends AbstractSequentialList<T> {
    private static final ImmutableLinkedList<Object> NIL = new ImmutableLinkedList<Object>(){
        private final ListIterator<Object> iterator = new IllIterator<Object>(this);

        @Override
        public Object head() {
            throw new UnsupportedOperationException("head of empty list");
        }

        @Override
        public ImmutableLinkedList<Object> tail() {
            throw new UnsupportedOperationException("tail of empty list");
        }

        @Override
        public Object last() {
            throw new UnsupportedOperationException("last of empty list");
        }

        @Override
        public ListIterator<Object> listIterator(int n) {
            return this.iterator;
        }
    };
    private final T head;
    private final ImmutableLinkedList<T> tail;

    public static <T> ImmutableLinkedList<T> nil() {
        return NIL;
    }

    private ImmutableLinkedList() {
        this.head = null;
        this.tail = null;
    }

    public ImmutableLinkedList(T t, ImmutableLinkedList<T> immutableLinkedList) {
        Preconditions.checkArgNotNull(immutableLinkedList, "tail");
        this.head = t;
        this.tail = immutableLinkedList;
    }

    public T head() {
        return this.head;
    }

    public ImmutableLinkedList<T> tail() {
        return this.tail;
    }

    public T last() {
        ImmutableLinkedList<T> immutableLinkedList = this;
        while (!immutableLinkedList.tail.isEmpty()) {
            immutableLinkedList = immutableLinkedList.tail();
        }
        return immutableLinkedList.head();
    }

    public ImmutableLinkedList<T> prepend(T t) {
        return new ImmutableLinkedList<T>(t, this);
    }

    public ImmutableLinkedList<T> reverse() {
        if (this.tail == NIL) {
            return this;
        }
        ImmutableLinkedList<T> immutableLinkedList = ImmutableLinkedList.nil();
        ImmutableLinkedList<T> immutableLinkedList2 = this;
        while (immutableLinkedList2 != NIL) {
            immutableLinkedList = immutableLinkedList.prepend(immutableLinkedList2.head);
            immutableLinkedList2 = immutableLinkedList2.tail;
        }
        return immutableLinkedList;
    }

    public static <T> boolean equal(ImmutableLinkedList<T> immutableLinkedList, ImmutableLinkedList<T> immutableLinkedList2) {
        Preconditions.checkArgNotNull(immutableLinkedList, "a");
        Preconditions.checkArgNotNull(immutableLinkedList2, "b");
        return Utils.equal(immutableLinkedList.head, immutableLinkedList2.head) && ImmutableLinkedList.equal(immutableLinkedList.tail, immutableLinkedList2.tail);
    }

    public static int hashCode(ImmutableLinkedList<?> immutableLinkedList) {
        Preconditions.checkArgNotNull(immutableLinkedList, "list");
        return immutableLinkedList.isEmpty() ? 0 : 31 * immutableLinkedList.head.hashCode() + ImmutableLinkedList.hashCode(immutableLinkedList.tail);
    }

    @Override
    public ListIterator<T> listIterator(int n) {
        IllIterator illIterator = new IllIterator(this);
        while (n-- > 0) {
            if (!illIterator.hasNext()) {
                throw new IndexOutOfBoundsException();
            }
            illIterator.next();
        }
        return illIterator;
    }

    @Override
    public boolean isEmpty() {
        return this == NIL;
    }

    @Override
    public int size() {
        ImmutableLinkedList<T> immutableLinkedList = this;
        int n = 0;
        while (!immutableLinkedList.isEmpty()) {
            ++n;
            immutableLinkedList = immutableLinkedList.tail();
        }
        return n;
    }

    private static class IllIterator<T>
    implements ListIterator<T> {
        private final ImmutableLinkedList<T> start;
        private ImmutableLinkedList<T> current;
        private int nextIndex = 0;

        private IllIterator(ImmutableLinkedList<T> immutableLinkedList) {
            this.start = immutableLinkedList;
            this.current = immutableLinkedList;
        }

        @Override
        public boolean hasNext() {
            return this.current != NIL;
        }

        @Override
        public T next() {
            ImmutableLinkedList<T> immutableLinkedList = this.current;
            this.current = this.current.tail;
            ++this.nextIndex;
            return immutableLinkedList.head;
        }

        @Override
        public boolean hasPrevious() {
            return this.current != this.start;
        }

        @Override
        public T previous() {
            ImmutableLinkedList<T> immutableLinkedList = this.start;
            while (immutableLinkedList.tail != this.current) {
                immutableLinkedList = immutableLinkedList.tail;
            }
            --this.nextIndex;
            return immutableLinkedList.head;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(T t) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(T t) {
            throw new UnsupportedOperationException();
        }
    }
}

