/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.parboiled.Context;
import org.parboiled.MatchHandler;
import org.parboiled.Node;
import org.parboiled.NodeImpl;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.ImmutableLinkedList;
import org.parboiled.common.Preconditions;
import org.parboiled.common.StringUtils;
import org.parboiled.errors.BasicParseError;
import org.parboiled.errors.ErrorUtils;
import org.parboiled.errors.GrammarException;
import org.parboiled.errors.ParseError;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.matchers.ActionMatcher;
import org.parboiled.matchers.Matcher;
import org.parboiled.matchers.MatcherUtils;
import org.parboiled.matchers.ProxyMatcher;
import org.parboiled.matchers.SequenceMatcher;
import org.parboiled.matchers.TestMatcher;
import org.parboiled.matchers.TestNotMatcher;
import org.parboiled.parserunners.RecoveringParseRunner;
import org.parboiled.support.Checks;
import org.parboiled.support.IndexRange;
import org.parboiled.support.MatcherPath;
import org.parboiled.support.MatcherPosition;
import org.parboiled.support.ParseTreeUtils;
import org.parboiled.support.Position;
import org.parboiled.support.ValueStack;

public class MatcherContext<V>
implements Context<V> {
    private final InputBuffer inputBuffer;
    private final ValueStack<V> valueStack;
    private final List<ParseError> parseErrors;
    private final MatchHandler matchHandler;
    private final MatcherContext<V> parent;
    private final int level;
    private final boolean fastStringMatching;
    private final Set<MatcherPosition> memoizedMismatches;
    private MatcherContext<V> subContext;
    private int startIndex;
    private int currentIndex;
    private char currentChar;
    private Matcher matcher;
    private Node<V> node;
    private ImmutableLinkedList<Node<V>> subNodes = ImmutableLinkedList.nil();
    private MatcherPath path;
    private int intTag;
    private boolean hasError;
    private boolean nodeSuppressed;
    private boolean inErrorRecovery;

    public MatcherContext(InputBuffer inputBuffer, ValueStack<V> valueStack, List<ParseError> list, MatchHandler matchHandler, Matcher matcher, boolean bl) {
        this(Preconditions.checkArgNotNull(inputBuffer, "inputBuffer"), Preconditions.checkArgNotNull(valueStack, "valueStack"), Preconditions.checkArgNotNull(list, "parseErrors"), Preconditions.checkArgNotNull(matchHandler, "matchHandler"), null, 0, bl, new HashSet<MatcherPosition>());
        this.currentChar = inputBuffer.charAt(0);
        this.matcher = ProxyMatcher.unwrap(Preconditions.checkArgNotNull(matcher, "matcher"));
        this.nodeSuppressed = matcher.isNodeSuppressed();
    }

    private MatcherContext(InputBuffer inputBuffer, ValueStack<V> valueStack, List<ParseError> list, MatchHandler matchHandler, MatcherContext<V> matcherContext, int n, boolean bl, Set<MatcherPosition> set) {
        this.inputBuffer = inputBuffer;
        this.valueStack = valueStack;
        this.parseErrors = list;
        this.matchHandler = matchHandler;
        this.parent = matcherContext;
        this.level = n;
        this.fastStringMatching = bl;
        this.memoizedMismatches = set;
    }

    public String toString() {
        return this.getPath().toString();
    }

    @Override
    public MatcherContext<V> getParent() {
        return this.parent;
    }

    @Override
    public InputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    @Override
    public int getStartIndex() {
        return this.startIndex;
    }

    @Override
    public Matcher getMatcher() {
        return this.matcher;
    }

    @Override
    public char getCurrentChar() {
        return this.currentChar;
    }

    @Override
    public List<ParseError> getParseErrors() {
        return this.parseErrors;
    }

    @Override
    public int getCurrentIndex() {
        return this.currentIndex;
    }

    @Override
    public MatcherPath getPath() {
        if (this.path == null) {
            this.path = new MatcherPath(new MatcherPath.Element(this.matcher, this.startIndex, this.level), this.parent != null ? this.parent.getPath() : null);
        }
        return this.path;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public boolean fastStringMatching() {
        return this.fastStringMatching;
    }

    @Override
    public ImmutableLinkedList<Node<V>> getSubNodes() {
        return this.matcher.isNodeSkipped() ? this.subNodes : MatcherContext.getSubNodes(this.subNodes, ImmutableLinkedList.nil());
    }

    private static <V> ImmutableLinkedList<Node<V>> getSubNodes(ImmutableLinkedList<Node<V>> immutableLinkedList, ImmutableLinkedList<Node<V>> immutableLinkedList2) {
        while (!immutableLinkedList.isEmpty()) {
            Node<V> node = immutableLinkedList.head();
            immutableLinkedList2 = node.getMatcher().isNodeSkipped() ? MatcherContext.getSubNodes((ImmutableLinkedList)node.getChildren(), immutableLinkedList2) : immutableLinkedList2.prepend(node);
            immutableLinkedList = immutableLinkedList.tail();
        }
        return immutableLinkedList2;
    }

    @Override
    public boolean inPredicate() {
        return this.matcher instanceof TestMatcher || this.matcher instanceof TestNotMatcher || this.parent != null && this.parent.inPredicate();
    }

    @Override
    public boolean inErrorRecovery() {
        return this.inErrorRecovery;
    }

    @Override
    public boolean isNodeSuppressed() {
        return this.nodeSuppressed;
    }

    @Override
    public boolean hasError() {
        return this.hasError;
    }

    @Override
    public String getMatch() {
        this.checkActionContext();
        MatcherContext<V> matcherContext = this.subContext;
        if (this.hasError) {
            Node<V> node = matcherContext.node;
            return node != null ? ParseTreeUtils.getNodeText(node, this.inputBuffer) : "";
        }
        return this.inputBuffer.extract(matcherContext.startIndex, matcherContext.currentIndex);
    }

    @Override
    public char getFirstMatchChar() {
        this.checkActionContext();
        int n = this.subContext.startIndex;
        if (this.subContext.currentIndex <= n) {
            throw new GrammarException("getFirstMatchChar called but previous rule did not match anything");
        }
        return this.inputBuffer.charAt(n);
    }

    @Override
    public int getMatchStartIndex() {
        this.checkActionContext();
        return this.subContext.startIndex;
    }

    @Override
    public int getMatchEndIndex() {
        this.checkActionContext();
        return this.subContext.currentIndex;
    }

    @Override
    public int getMatchLength() {
        this.checkActionContext();
        return this.subContext.currentIndex - this.subContext.getStartIndex();
    }

    @Override
    public Position getPosition() {
        return this.inputBuffer.getPosition(this.currentIndex);
    }

    @Override
    public IndexRange getMatchRange() {
        this.checkActionContext();
        return new IndexRange(this.subContext.startIndex, this.subContext.currentIndex);
    }

    private void checkActionContext() {
        Checks.ensure(MatcherUtils.unwrap(this.matcher) instanceof SequenceMatcher && this.intTag > 0 && this.subContext.matcher instanceof ActionMatcher, "Illegal call to getMatch(), getMatchStartIndex(), getMatchEndIndex() or getMatchRange(), only valid in Sequence rule actions that are not in first position");
    }

    @Override
    public ValueStack<V> getValueStack() {
        return this.valueStack;
    }

    public void setMatcher(Matcher matcher) {
        this.matcher = matcher;
    }

    public void setStartIndex(int n) {
        Preconditions.checkArgument(n >= 0);
        this.startIndex = n;
    }

    public void setCurrentIndex(int n) {
        Preconditions.checkArgument(n >= 0);
        this.currentIndex = n;
        this.currentChar = this.inputBuffer.charAt(n);
    }

    public void setInErrorRecovery(boolean bl) {
        this.inErrorRecovery = bl;
    }

    public void advanceIndex(int n) {
        this.currentIndex += n;
        this.currentChar = this.inputBuffer.charAt(this.currentIndex);
    }

    public Node<V> getNode() {
        return this.node;
    }

    public int getIntTag() {
        return this.intTag;
    }

    public void setIntTag(int n) {
        this.intTag = n;
    }

    public void markError() {
        if (!this.hasError) {
            this.hasError = true;
            if (this.parent != null) {
                this.parent.markError();
            }
        }
    }

    public Boolean hasMismatched() {
        return this.memoizedMismatches.contains(MatcherPosition.at(this.matcher, this.currentIndex));
    }

    public void memoizeMismatch() {
        this.memoizedMismatches.add(MatcherPosition.at(this.matcher, this.currentIndex));
    }

    public void createNode() {
        if (!this.nodeSuppressed) {
            this.node = new NodeImpl<Object>(this.matcher, (ImmutableLinkedList<Node<Object>>)this.getSubNodes(), this.startIndex, this.currentIndex, (this.valueStack.isEmpty() ? null : (Object)this.valueStack.peek()), this.hasError);
            if (this.parent != null) {
                this.parent.subNodes = this.parent.subNodes.prepend(this.node);
            }
        }
    }

    public final MatcherContext<V> getBasicSubContext() {
        if (this.subContext == null) {
            this.subContext = new MatcherContext<V>(this.inputBuffer, this.valueStack, this.parseErrors, this.matchHandler, this, this.level + 1, this.fastStringMatching, this.memoizedMismatches);
        } else {
            this.subContext.path = null;
        }
        return this.subContext;
    }

    public final MatcherContext<V> getSubContext(Matcher matcher) {
        MatcherContext<V> matcherContext = this.getBasicSubContext();
        matcherContext.matcher = matcher;
        matcherContext.startIndex = matcherContext.currentIndex = this.currentIndex;
        matcherContext.currentChar = this.currentChar;
        matcherContext.node = null;
        matcherContext.subNodes = ImmutableLinkedList.nil();
        matcherContext.nodeSuppressed = this.nodeSuppressed || this.matcher.areSubnodesSuppressed() || matcher.isNodeSuppressed();
        matcherContext.hasError = false;
        return matcherContext;
    }

    public boolean runMatcher() {
        try {
            if (this.matchHandler.match(this)) {
                if (this.parent != null) {
                    this.parent.currentIndex = this.currentIndex;
                    this.parent.currentChar = this.currentChar;
                }
                this.matcher = null;
                return true;
            }
            this.matcher = null;
            return false;
        }
        catch (ParserRuntimeException parserRuntimeException) {
            throw parserRuntimeException;
        }
        catch (RecoveringParseRunner.TimeoutException timeoutException) {
            throw timeoutException;
        }
        catch (Throwable throwable) {
            throw new ParserRuntimeException(throwable, ErrorUtils.printParseError(new BasicParseError(this.inputBuffer, this.currentIndex, StringUtils.escape(String.format("Error while parsing %s '%s' at input position", this.matcher instanceof ActionMatcher ? "action" : "rule", this.getPath())))) + "\n" + throwable, new Object[0]);
        }
    }
}

