/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import java.util.Arrays;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.IntArrayStack;
import org.parboiled.common.Preconditions;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

public class DefaultInputBuffer
implements InputBuffer {
    private final int length;
    private final char[] buffer;
    private int[] newlines;

    public DefaultInputBuffer(char[] cArray) {
        Preconditions.checkArgNotNull(cArray, "buffer");
        this.buffer = cArray;
        this.length = cArray.length;
    }

    public char charAt(int n) {
        return 0 <= n && n < this.length ? this.buffer[n] : (char)'\uffff';
    }

    public boolean test(int n, char[] cArray) {
        int n2 = cArray.length;
        if (n < 0 || n > this.length - n2) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            if (this.buffer[n + i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    public String extract(int n, int n2) {
        if (n < 0) {
            n = 0;
        }
        if (n2 >= this.length) {
            n2 = this.length;
        }
        if (n2 <= n) {
            return "";
        }
        return new String(this.buffer, n, n2 - n);
    }

    public String extract(IndexRange indexRange) {
        return new String(this.buffer, indexRange.start, Math.min(indexRange.end, this.length) - indexRange.start);
    }

    public Position getPosition(int n) {
        this.buildNewlines();
        int n2 = DefaultInputBuffer.getLine0(this.newlines, n);
        int n3 = n - (n2 > 0 ? this.newlines[n2 - 1] : -1);
        return new Position(n2 + 1, n3);
    }

    public int getOriginalIndex(int n) {
        return n;
    }

    private static int getLine0(int[] nArray, int n) {
        int n2 = Arrays.binarySearch(nArray, n);
        return n2 >= 0 ? n2 : -(n2 + 1);
    }

    public String extractLine(int n) {
        int n2;
        this.buildNewlines();
        Preconditions.checkArgument(0 < n && n <= this.newlines.length + 1);
        int n3 = n > 1 ? this.newlines[n - 2] + 1 : 0;
        int n4 = n2 = n <= this.newlines.length ? this.newlines[n - 1] : this.length;
        if (this.charAt(n2 - 1) == '\r') {
            --n2;
        }
        return this.extract(n3, n2);
    }

    public int getLineCount() {
        this.buildNewlines();
        return this.newlines.length + 1;
    }

    private void buildNewlines() {
        if (this.newlines == null) {
            IntArrayStack intArrayStack = new IntArrayStack();
            for (int i = 0; i < this.length; ++i) {
                if (this.buffer[i] != '\n') continue;
                intArrayStack.push(i);
            }
            this.newlines = new int[intArrayStack.size()];
            intArrayStack.getElements(this.newlines, 0);
        }
    }
}

