/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.trees;

import java.util.Collection;
import java.util.HashSet;
import org.parboiled.common.Formatter;
import org.parboiled.common.Preconditions;
import org.parboiled.common.Predicate;
import org.parboiled.common.Predicates;
import org.parboiled.trees.GraphNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphUtils {
    private GraphUtils() {
    }

    public static boolean hasChildren(GraphNode<?> node) {
        return node != null && !node.getChildren().isEmpty();
    }

    public static <T extends GraphNode<T>> T getFirstChild(T node) {
        return (T)(GraphUtils.hasChildren(node) ? (GraphNode)node.getChildren().get(0) : null);
    }

    public static <T extends GraphNode<T>> T getLastChild(T node) {
        return (T)(GraphUtils.hasChildren(node) ? (GraphNode)node.getChildren().get(node.getChildren().size() - 1) : null);
    }

    public static <T extends GraphNode<T>> int countAllDistinct(T node) {
        if (node == null) {
            return 0;
        }
        return GraphUtils.collectAllNodes(node, new HashSet()).size();
    }

    public static <T extends GraphNode<T>, C extends Collection<T>> C collectAllNodes(T node, C collection) {
        Preconditions.checkArgNotNull(collection, "collection");
        if (node != null && !collection.contains(node)) {
            collection.add(node);
            for (GraphNode child : node.getChildren()) {
                GraphUtils.collectAllNodes(child, collection);
            }
        }
        return collection;
    }

    public static <T extends GraphNode<T>> String printTree(T node, Formatter<T> formatter) {
        Preconditions.checkArgNotNull(formatter, "formatter");
        return GraphUtils.printTree(node, formatter, Predicates.alwaysTrue(), Predicates.alwaysTrue());
    }

    public static <T extends GraphNode<T>> String printTree(T node, Formatter<T> formatter, Predicate<T> nodeFilter, Predicate<T> subTreeFilter) {
        Preconditions.checkArgNotNull(formatter, "formatter");
        Preconditions.checkArgNotNull(nodeFilter, "nodeFilter");
        Preconditions.checkArgNotNull(subTreeFilter, "subTreeFilter");
        return node == null ? "" : GraphUtils.printTree(node, formatter, "", new StringBuilder(), nodeFilter, subTreeFilter).toString();
    }

    private static <T extends GraphNode<T>> StringBuilder printTree(T node, Formatter<T> formatter, String indent, StringBuilder sb, Predicate<T> nodeFilter, Predicate<T> subTreeFilter) {
        String line;
        if (nodeFilter.apply(node) && (line = formatter.format(node)) != null) {
            sb.append(indent).append(line).append("\n");
            indent = indent + "  ";
        }
        if (subTreeFilter.apply(node)) {
            for (GraphNode sub : node.getChildren()) {
                GraphUtils.printTree(sub, formatter, indent, sb, nodeFilter, subTreeFilter);
            }
        }
        return sb;
    }
}

